/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.AbstractConnectionFactory;
import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.AuthingableConnectionManager;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.ConnectionFactory;
import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.ConnectionObserver;
import com.meidusa.toolkit.net.NetEventHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ServerableConnectionManager
extends AuthingableConnectionManager {
    protected static Logger log = Logger.getLogger(ServerableConnectionManager.class);
    private ConnectionObserver connObserver = new AuthingConnectionObserver();
    protected int port;
    protected ServerSocketChannel ssocket;
    protected String ipAddress;
    protected ConnectionFactory connFactory;
    private ConnectionManager[] managers;
    private int subManagerSize = Runtime.getRuntime().availableProcessors();
    private AtomicLong counter = new AtomicLong();
    private int backlog = 128;

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int maxBacklogQueue) {
        this.backlog = maxBacklogQueue;
    }

    public int getSubManagerSize() {
        return this.subManagerSize;
    }

    public void setSubManagerSize(int subManagerSize) {
        this.subManagerSize = subManagerSize;
    }

    public ServerableConnectionManager() throws IOException {
    }

    public ServerableConnectionManager(String name, int port) throws IOException {
        super(name);
        this.port = port;
    }

    public ServerableConnectionManager(String name, String ipAddress, int port) throws IOException {
        this(name, port);
        this.ipAddress = ipAddress;
    }

    public void setConnectionFactory(ConnectionFactory connFactory) {
        AbstractConnectionFactory afactory;
        this.connFactory = connFactory;
        if (connFactory instanceof AbstractConnectionFactory && (afactory = (AbstractConnectionFactory)connFactory).getConnectionManager() == null) {
            afactory.setConnectionManager(this);
        }
    }

    protected void initSubManager(ConnectionManager manager) {
        manager.setExecutor(this.getExecutor());
        manager.setDaemon(true);
        manager._observers = this._observers;
        manager.setIdleCheckTime(this.getIdleCheckTime());
        manager.setMaxQueueSizePerClient(this.getMaxQueueSizePerClient());
    }

    protected ConnectionManager newInstanceSubManager(int index) throws IOException {
        return new ConnectionManager(String.valueOf(this.getName()) + "-" + index);
    }

    @Override
    protected void willStart() {
        this.addConnectionObserver(this.connObserver);
        this.managers = new ConnectionManager[this.subManagerSize > 0 ? this.subManagerSize : Runtime.getRuntime().availableProcessors()];
        int i = 0;
        while (i < this.managers.length) {
            try {
                this.managers[i] = this.newInstanceSubManager(i);
                this.initSubManager(this.managers[i]);
                this.managers[i].start();
            }
            catch (IOException ioe) {
                log.error((Object)"create sub manager error", (Throwable)ioe);
                throw new RuntimeException(ioe);
            }
            ++i;
        }
        super.willStart();
        try {
            this.ssocket = ServerSocketChannel.open();
            this.ssocket.configureBlocking(false);
            InetSocketAddress isa = null;
            isa = this.ipAddress != null ? new InetSocketAddress(this.ipAddress, this.port) : new InetSocketAddress(this.port);
            Level level = log.getLevel();
            log.setLevel(Level.INFO);
            this.ssocket.socket().bind(isa, this.backlog);
            this.registerServerChannel(this.ssocket);
            log.info((Object)("Server listening on " + isa + "."));
            log.setLevel(level);
        }
        catch (IOException ioe) {
            log.error((Object)("Failure listening to socket on port '" + this.port + "'."), (Throwable)ioe);
            System.exit(-1);
        }
    }

    protected void registerServerChannel(final ServerSocketChannel listener) throws IOException {
        NetEventHandler serverNetEvent = new NetEventHandler(){
            private SelectionKey key;

            @Override
            public int handleEvent(long when) {
                Connection conn = null;
                while ((conn = ServerableConnectionManager.this.acceptConnection(listener)) != null) {
                }
                return 0;
            }

            @Override
            public boolean checkIdle(long now) {
                return false;
            }

            @Override
            public SelectionKey getSelectionKey() {
                return this.key;
            }

            @Override
            public void setSelectionKey(SelectionKey key) {
                this.key = key;
            }

            @Override
            public boolean doWrite() {
                return true;
            }

            @Override
            public boolean needPing(long now) {
                return false;
            }

            @Override
            public void ping(long now) {
            }

            @Override
            public long getQueueSize() {
                return -1L;
            }
        };
        SelectionKey sk = listener.register(this._selector, 16, serverNetEvent);
        serverNetEvent.setSelectionKey(sk);
        this.postRegisterNetEventHandler(serverNetEvent, 16);
    }

    protected Connection acceptConnection(ServerSocketChannel listener) {
        SocketChannel channel;
        block10: {
            block9: {
                channel = null;
                try {
                    channel = listener.accept();
                    if (channel != null) break block9;
                    return null;
                }
                catch (Exception e) {
                    if (channel != null) {
                        try {
                            channel.socket().close();
                        }
                        catch (IOException ioe) {
                            log.warn((Object)("Failed closing aborted connection: " + ioe));
                        }
                    }
                    return null;
                }
            }
            if (channel instanceof SelectableChannel) break block10;
            try {
                log.warn((Object)("Provided with un-selectable socket as result of accept(), can't cope [channel=" + channel + "]."));
            }
            catch (Error err) {
                log.warn((Object)"Un-selectable channel also couldn't be printed.");
            }
            channel.socket().close();
            return null;
        }
        Connection connection = this.connFactory.createConnection(channel, System.currentTimeMillis());
        this.postRegisterNetEventHandler(connection, 1);
        return connection;
    }

    @Override
    public void postRegisterNetEventHandler(NetEventHandler handler, int key) {
        if (handler instanceof Connection) {
            long count = this.counter.incrementAndGet();
            this.managers[(int)count % this.managers.length].postRegisterNetEventHandler(handler, key);
        } else {
            super.postRegisterNetEventHandler(handler, key);
        }
    }

    @Override
    public void closeAll() {
        super.closeAll();
        try {
            this.ssocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        try {
            this.ssocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.managers != null) {
            ConnectionManager[] connectionManagerArray = this.managers;
            int n = this.managers.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionManager conM = connectionManagerArray[n2];
                conM.shutdown();
                ++n2;
            }
        }
    }

    class AuthingConnectionObserver
    implements ConnectionObserver {
        AuthingConnectionObserver() {
        }

        @Override
        public void connectionClosed(Connection conn) {
        }

        @Override
        public void connectionEstablished(Connection connection) {
            if (connection instanceof AuthingableConnection) {
                ((AuthingableConnection)connection).setAuthenticateProvider(ServerableConnectionManager.this.getAuthenticateProvider());
                ((AuthingableConnection)connection).beforeAuthing();
            }
        }

        @Override
        public void connectionFailed(Connection conn, Exception fault) {
        }
    }
}

