/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.NetEventHandler;
import com.meidusa.toolkit.net.io.PacketInputStream;
import com.meidusa.toolkit.net.io.PacketOutputStream;
import com.meidusa.toolkit.net.io.Sessionable;
import com.meidusa.toolkit.net.packet.Packet;
import com.meidusa.toolkit.net.packet.PacketFactory;
import com.meidusa.toolkit.net.util.ByteUtil;
import com.meidusa.toolkit.net.util.MemoryQueue;
import com.meidusa.toolkit.net.util.StringUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class Connection
implements NetEventHandler {
    private static Logger logger = Logger.getLogger(Connection.class);
    private static Logger packetDumpLogger = Logger.getLogger((String)"packetDump");
    private String id;
    public static final long PING_INTERVAL = 90000L;
    protected static final long LATENCY_GRACE = 30000L;
    protected long pingIterval = 90000L;
    protected ConnectionManager _cmgr;
    protected SelectionKey _selkey;
    protected SocketChannel _channel;
    protected long _lastEvent;
    private long _createTime = System.currentTimeMillis();
    private MessageHandler<Connection> _handler;
    protected final Object writeLock = new Object();
    protected final Lock closeLock = new ReentrantLock(false);
    protected final Lock postCloseLock = new ReentrantLock(false);
    protected AtomicLong queueSize = new AtomicLong();
    private ExecutorService executor;
    protected boolean closePosted = false;
    private PacketInputStream _fin;
    protected long lastMessageSent = System.currentTimeMillis();
    private PacketOutputStream _fout;
    protected MemoryQueue<ByteBuffer> _outQueue = new MemoryQueue();
    private boolean socketClosed = false;
    protected String host;
    protected int port;
    private ReadableByteChannel _rChannel;
    private WritableByteChannel _wChannel;
    protected PacketFactory<? extends Packet> packetFactory;

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public Connection(SocketChannel channel, long createStamp) {
        this._channel = channel;
        if (channel instanceof ReadableByteChannel) {
            this._rChannel = channel;
        }
        if (channel instanceof WritableByteChannel) {
            this._wChannel = channel;
        }
        this.host = channel.socket().getInetAddress().getHostAddress();
        this.port = channel.socket().getPort();
        this.setId(String.valueOf(this.host) + ":" + this.port);
        this._lastEvent = createStamp;
        this._createTime = createStamp;
    }

    public PacketFactory<? extends Packet> getPacketFactory() {
        return this.packetFactory;
    }

    public void setPacketFactory(PacketFactory<? extends Packet> packetFactory) {
        this.packetFactory = packetFactory;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getPingIterval() {
        return this.pingIterval;
    }

    public void setPingIterval(long pingIterval) {
        this.pingIterval = pingIterval;
    }

    protected void init() {
        if (this._outQueue.size() > 0) {
            this._selkey.interestOps(this._selkey.interestOps() | 4);
        }
    }

    public void setOutQueueMaxSize(int maxSize) {
        this._outQueue.setMaxSize(maxSize);
    }

    public void setConnectionManager(ConnectionManager cmgr) {
        this._cmgr = cmgr;
    }

    @Override
    public void setSelectionKey(SelectionKey selkey) {
        this._selkey = selkey;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this._selkey;
    }

    public SocketChannel getChannel() {
        return this._channel;
    }

    public void setMessageHandler(MessageHandler handler) {
        this._handler = handler;
    }

    public MessageHandler getMessageHandler() {
        return this._handler;
    }

    protected void inheritStreams(Connection other) {
        this._fin = other._fin;
        this._fout = other._fout;
    }

    public boolean isClosed() {
        this.closeLock.lock();
        try {
            boolean bl = this.socketClosed || this.getChannel() == null || !this.getChannel().isOpen();
            return bl;
        }
        finally {
            this.closeLock.unlock();
        }
    }

    protected void close(Exception exception) {
        this.closeLock.lock();
        try {
            if (this.isClosed()) {
                return;
            }
            this.socketClosed = true;
        }
        finally {
            this.closeLock.unlock();
        }
        this._outQueue.clear();
        if (this.getMessageHandler() instanceof Sessionable) {
            Sessionable session = (Sessionable)((Object)this.getMessageHandler());
            logger.error((Object)(this + ",closeSocket,and endSession,handler=" + session));
            session.endSession();
        }
        if (this._selkey != null) {
            this._selkey.attach(null);
            Selector selector = this._selkey.selector();
            this._selkey.cancel();
            selector.wakeup();
            this._selkey = null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Closing channel " + this + ",id=" + this.id + ", manager=" + this._cmgr.getName()));
        }
        try {
            this._channel.close();
        }
        catch (IOException ioe) {
            logger.warn((Object)("Error closing connection [conn=" + this + ",id=" + this.id + ", manager=" + this._cmgr.getName() + ", error=" + ioe + "]."));
        }
        if (exception != null) {
            this._cmgr.connectionFailed(this, exception);
        } else {
            this._cmgr.connectionClosed(this);
        }
    }

    public void postClose(Exception exception) {
        if (this.closePosted) {
            return;
        }
        this.postCloseLock.lock();
        try {
            this._cmgr.closeConnection(this, exception);
        }
        finally {
            this.postCloseLock.unlock();
        }
    }

    public void handleFailure(Exception ioe) {
        if (this.isClosed()) {
            logger.warn((Object)("Failure reported on closed connection " + this + "."), (Throwable)ioe);
            return;
        }
        this.postClose(ioe);
    }

    @Override
    public int handleEvent(long when) {
        int bytesInTotle = 0;
        try {
            if (this._fin == null) {
                this._fin = this.createPacketInputStream();
            }
            while (this._channel != null && this._channel.isOpen() && this._fin.readPacket(this._rChannel)) {
                int bytesIn = 0;
                this._lastEvent = when;
                bytesIn = this._fin.available();
                bytesInTotle += bytesIn;
                byte[] msg = new byte[bytesIn];
                this._fin.read(msg);
                this.messageProcess(msg);
            }
        }
        catch (EOFException eofe) {
            this.handleFailure(eofe);
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (msg == null || msg.indexOf("reset by peer") == -1) {
                logger.info((Object)("Error reading message from socket [channel=" + StringUtil.safeToString(this._channel) + ", error=" + ioe + "]."), (Throwable)ioe);
            }
            this.handleFailure(ioe);
        }
        return bytesInTotle;
    }

    protected void messageProcess(final byte[] msg) {
        if (this.closePosted || this.isClosed()) {
            return;
        }
        if (this.executor != null) {
            this.queueSize.incrementAndGet();
            Runnable task = new Runnable(){
                long start = System.currentTimeMillis();

                @Override
                public void run() {
                    try {
                        Connection.this.getMessageHandler().handleMessage(Connection.this, msg);
                    }
                    finally {
                        Connection.this.queueSize.decrementAndGet();
                        Connection.this.logInvokeTime(this.start, msg);
                    }
                }
            };
            this.executor.execute(task);
        } else {
            long start = System.currentTimeMillis();
            try {
                this.getMessageHandler().handleMessage(this, msg);
            }
            finally {
                this.logInvokeTime(start, msg);
            }
        }
    }

    protected void logInvokeTime(long start, byte[] msg) {
        long cost = System.currentTimeMillis() - start;
        if (cost <= 11500L) {
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.getId());
                buffer.append(" request Completed, time=");
                buffer.append(cost);
                if (packetDumpLogger.isDebugEnabled() && msg != null) {
                    buffer.append("\r\n").append("--------------------").append("\r\n");
                    buffer.append(ByteUtil.toHex(msg, 0, msg.length));
                    buffer.append("\r\n").append("--------------------").append("\r\n");
                }
                logger.debug((Object)buffer.toString());
            }
        } else if (logger.isEnabledFor((Priority)Level.WARN)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getId());
            buffer.append(" request Completed, time=");
            buffer.append(cost);
            if (packetDumpLogger.isDebugEnabled() && msg != null) {
                buffer.append("\r\n").append("--------------------").append("\r\n");
                buffer.append(ByteUtil.toHex(msg, 0, msg.length));
                buffer.append("\r\n").append("--------------------").append("\r\n");
            }
            logger.warn((Object)buffer.toString());
        }
    }

    @Override
    public long getQueueSize() {
        return this.queueSize.get();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean doWrite() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void postMessage(byte[] msg) {
        PacketOutputStream _framer = this.getPacketOutputStream();
        _framer.resetPacket();
        try {
            _framer.write(msg);
            ByteBuffer buffer = _framer.returnPacketBuffer();
            this.postMessage(buffer);
        }
        catch (IOException e) {
            this._cmgr.connectionFailed(this, e);
        }
    }

    public void postMessage(ByteBuffer msg) {
        this.lastMessageSent = System.currentTimeMillis();
        this._outQueue.append(msg);
        try {
            this.doWrite();
        }
        catch (IOException ioe) {
            this.handleFailure(ioe);
        }
        catch (CancelledKeyException ce) {
            this.handleFailure(ce);
        }
    }

    @Override
    public boolean checkIdle(long now) {
        long idleMillis = now - this._lastEvent;
        if (idleMillis < this.getPingIterval() + 30000L) {
            return false;
        }
        if (this.isClosed()) {
            return true;
        }
        return true;
    }

    public long getLastEventTime() {
        return this._lastEvent;
    }

    @Override
    public boolean needPing(long now) {
        return false;
    }

    protected abstract PacketInputStream createPacketInputStream();

    protected abstract PacketOutputStream createPacketOutputStream();

    protected PacketOutputStream getPacketOutputStream() {
        if (this._fout == null) {
            this._fout = this.createPacketOutputStream();
            this._fout.initHeader();
        }
        return this._fout;
    }

    protected PacketInputStream getPacketInputStream() {
        if (this._fin == null) {
            this._fin = this.createPacketInputStream();
        }
        return this._fin;
    }

    public ConnectionManager getConnectionManager() {
        return this._cmgr;
    }

    public InetAddress getInetAddress() {
        return this._channel == null ? null : this._channel.socket().getInetAddress();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("class=").append(this.getClass()).append(",socket=").append(this.getId()).append(",outQueue=").append(this._outQueue.size()).append(",createTime=").append(new Date(this._createTime));
        return buffer.toString();
    }
}

