/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.AbstractConnectionFactory;
import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.Connection;
import java.io.IOException;
import java.nio.channels.SocketChannel;

public abstract class AuthingableConnectionFactory
extends AbstractConnectionFactory {
    private int timeOut = 15000;

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    @Override
    public Connection createConnection(SocketChannel channel, long createStamp) throws IOException {
        AuthingableConnection connection = (AuthingableConnection)super.createConnection(channel, createStamp);
        connection.setAuthingTimeout(this.timeOut);
        this.waitforAuthenticate(connection);
        return connection;
    }

    protected void waitforAuthenticate(Connection connection) {
        if (connection instanceof AuthingableConnection) {
            AuthingableConnection authconn = (AuthingableConnection)connection;
            if (this.getTimeOut() > 0) {
                authconn.isAuthenticatedWithBlocked(this.getTimeOut());
            }
        }
    }
}

