/*
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details. 
 * 	You should have received a copy of the GNU General Public License along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.meidusa.toolkit.net.io;

import com.meidusa.toolkit.net.io.PacketInputStream;


/**
 * 
 * 
 * 
 * @author <a href=mailto:piratebase@sina.com>Struct chen</a>
 * 
 */
public class FramedInputStream extends PacketInputStream{

	private boolean readPackedWithHead;
	private AbstractPacketMetaData metaData;
	
	public FramedInputStream(AbstractPacketMetaData metaData ,boolean readPackedWithHead){
		this.readPackedWithHead = readPackedWithHead;
		this._buffer.order(metaData.getByteOrder());
		this.metaData = metaData;
	}

	protected int decodeLength() {
		
		/**
		 * жһǵǰѾȡݰǷȰͷ,:Լĳ,򷵻-1
		 */
		if (_have < metaData.getHeaderSize()) {
			return -1;
		}

		int length = metaData.decodeLength(_buffer);
		_buffer.position(_have);
		return length;
	}

    
    /**
     *  
     * @return packet header size
     */
    public int getHeaderSize(){
    	return metaData.getHeaderSize();
    }
	
	protected boolean checkForCompletePacket ()
    {
        if (_length == -1 || _have < _length) {
            return false;
        }
        //buffer ݰͷ
        if(readPackedWithHead){
        	_buffer.position(0);
        }else{
        	_buffer.position(metaData.getHeaderSize());
        }
        _buffer.limit(_length);
        
        return true;
    }
}