/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.io;

import com.meidusa.toolkit.net.io.AbstractPacketMetaData;
import com.meidusa.toolkit.net.io.PacketInputStream;

public class FramedInputStream
extends PacketInputStream {
    private boolean readPackedWithHead;
    private AbstractPacketMetaData metaData;

    public FramedInputStream(AbstractPacketMetaData metaData, boolean readPackedWithHead) {
        this.readPackedWithHead = readPackedWithHead;
        this._buffer.order(metaData.getByteOrder());
        this.metaData = metaData;
    }

    @Override
    protected int decodeLength() {
        if (this._have < this.metaData.getHeaderSize()) {
            return -1;
        }
        int length = this.metaData.decodeLength(this._buffer);
        this._buffer.position(this._have);
        return length;
    }

    @Override
    public int getHeaderSize() {
        return this.metaData.getHeaderSize();
    }

    @Override
    protected boolean checkForCompletePacket() {
        if (this._length == -1 || this._have < this._length) {
            return false;
        }
        if (this.readPackedWithHead) {
            this._buffer.position(0);
        } else {
            this._buffer.position(this.metaData.getHeaderSize());
        }
        this._buffer.limit(this._length);
        return true;
    }
}

