/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.net.AuthingableConnectionManager;
import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.NetEventHandler;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MultiConnectionManagerWrapper
extends ConnectionManager {
    private static Logger log = Logger.getLogger(MultiConnectionManagerWrapper.class);
    private static final AtomicLong createdCounter = new AtomicLong();
    private AtomicLong counter = new AtomicLong();
    public ConnectionManager[] connMgrs;
    private String subManagerClassName;
    private int processors = Runtime.getRuntime().availableProcessors();

    public void setSubManagerClassName(String className) {
        this.subManagerClassName = className;
    }

    public void setProcessors(int processors) {
        this.processors = processors;
    }

    public MultiConnectionManagerWrapper(ConnectionManager ... connMgrs) throws IOException {
        int managers = Integer.valueOf(System.getProperty("managers", "0"));
        this.processors += managers;
        this.setName("Toolkit-MultiConnectionManager-" + createdCounter.addAndGet(1L));
        this.connMgrs = connMgrs;
    }

    public MultiConnectionManagerWrapper() throws IOException {
        int managers = Integer.valueOf(System.getProperty("managers", "0"));
        this.processors += managers;
        this.setName("Toolkit-MultiConnectionManager-" + createdCounter.addAndGet(1L));
    }

    @Override
    public void postRegisterNetEventHandler(NetEventHandler handler, int key) {
        if (this.connMgrs != null) {
            long count = this.counter.incrementAndGet();
            this.connMgrs[(int)count % this.connMgrs.length].postRegisterNetEventHandler(handler, key);
        } else {
            super.postRegisterNetEventHandler(handler, key);
        }
    }

    @Override
    public void run() {
        if (this.connMgrs == null) {
            super.run();
        }
    }

    @Override
    public void init() throws InitialisationException {
        if (this.connMgrs == null || this.connMgrs.length < 1 || this.connMgrs[0] == null) {
            if (this.subManagerClassName == null) {
                this.subManagerClassName = ConnectionManager.class.getName();
            }
            this.connMgrs = new ConnectionManager[this.processors];
            for (int i = 0; i < this.processors; ++i) {
                try {
                    this.connMgrs[i] = (ConnectionManager)Class.forName(this.subManagerClassName).newInstance();
                    this.connMgrs[i].setName(this.getName() + "-" + i);
                    this.connMgrs[i].setIdleCheckTime(this.getIdleCheckTime());
                    this.connMgrs[i]._observers.addAll(this._observers);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"create sub manager error", (Throwable)e);
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        }
        Level level = log.getLevel();
        log.setLevel(Level.INFO);
        log.info((Object)(this.getName() + " LoopingThread willStart...."));
        log.setLevel(level);
        if (this.connMgrs != null) {
            for (int i = 0; i < this.connMgrs.length; ++i) {
                if (this.connMgrs[i] instanceof AuthingableConnectionManager) {
                    AuthingableConnectionManager authingableConnectionManager = (AuthingableConnectionManager)this.connMgrs[i];
                }
                if (this.connMgrs[i].isAlive()) continue;
                this.connMgrs[i].start();
                log.info((Object)(this.connMgrs[i].getName() + " connectionManager willStart...."));
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.connMgrs != null) {
            for (int i = 0; i < this.connMgrs.length; ++i) {
                this.connMgrs[i].shutdown();
            }
        }
        super.shutdown();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        if (this.connMgrs != null) {
            for (ConnectionManager manager : this.connMgrs) {
                size += manager.getSize();
            }
        }
        return size;
    }
}

