/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class ClientSideConnection
extends Connection
implements MessageHandler {
    private BlockingQueue<byte[]> inputQueue = new LinkedBlockingQueue<byte[]>();
    private long timeout;

    public ClientSideConnection(SocketChannel channel, long createStamp) {
        super(channel, createStamp);
        this.setMessageHandler(this);
    }

    public void setSoTimeout(long mils) {
        this.timeout = mils;
    }

    @Override
    public void ping(long now) {
    }

    public void handleMessage(Connection conn, byte[] message) {
        this.inputQueue.offer(message);
    }

    public byte[] readPacket() throws IOException {
        try {
            byte[] message = null;
            message = this.timeout > 0L ? this.inputQueue.poll(this.timeout, TimeUnit.MILLISECONDS) : (byte[])this.inputQueue.poll();
            if (message == null) {
                throw new IOException("read Packet timeout");
            }
            return message;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public boolean hasPacket() {
        return this.inputQueue.size() > 0;
    }

    public void write(byte[] message) {
        this.postMessage(message);
    }
}

