/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.util;

import com.meidusa.toolkit.net.util.BlockingQueue;
import com.meidusa.toolkit.net.util.MemoryQueue;

public class BlockingMemoryQueue<T>
extends MemoryQueue<T>
implements BlockingQueue<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T getNonBlocking() {
        try {
            Object t = super.getNonBlocking();
            return t;
        }
        finally {
            this.notify();
        }
    }

    @Override
    public synchronized void append(T item) {
        this.append0(item, this._count == 0);
    }

    public synchronized void appendSilent(T item) {
        this.append0(item, false);
    }

    @Override
    public synchronized void prepend(T item) {
        super.prepend(item);
        if (this._count == 1) {
            this.notify();
        }
    }

    public synchronized void appendLoud(T item) {
        this.append0(item, true);
    }

    public synchronized void waitForItem() {
        while (this._count == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public synchronized T get(long maxwait) {
        if (this._count == 0) {
            try {
                this.wait(maxwait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this._count == 0) {
                return null;
            }
        }
        return this.get();
    }

    @Override
    public synchronized T get() {
        while (this._count == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        Object retval = this._items[this._start];
        this._items[this._start] = null;
        this._start = (this._start + 1) % this._size;
        boolean needNotify = this._count >= this.maxSize && this.maxSize > 0;
        --this._count;
        if (this._size > 1024 && this._size > this._suggestedSize && this._count < this._size >> 3) {
            this.shrink();
        }
        if (needNotify) {
            this.notify();
        }
        return (T)retval;
    }
}

