/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.packet;

import com.meidusa.toolkit.net.IllegalPacketException;
import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public abstract class GenericIOPacketBuffer
extends AbstractPacketBuffer {
    public abstract int getHeadSize();

    public GenericIOPacketBuffer(byte[] buf) {
        super(buf);
    }

    public GenericIOPacketBuffer(int size) {
        super(size);
    }

    final void dumpHeader() {
        int i = 0;
        while (i < this.getHeadSize()) {
            String hexVal = Integer.toHexString(this.readByte(i) & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(String.valueOf(hexVal) + " ");
            ++i;
        }
    }

    public final byte[] getBytes(int len) {
        byte[] b = new byte[len];
        this.buffer.get(b);
        return b;
    }

    public byte[] getBytes(int offset, int len) {
        byte[] dest = new byte[len];
        System.arraycopy(this.buffer, offset, dest, 0, len);
        return dest;
    }

    public abstract long readFieldLength();

    public final int readInt() {
        return this.buffer.getInt();
    }

    public final long readLong() {
        return this.buffer.getLong();
    }

    public int writeLengthCodedBytes(byte[] ab) {
        this.ensureCapacity(ab.length + 4);
        this.writeInt(ab == null ? 0 : ab.length);
        if (ab != null && ab.length > 0) {
            return this.writeBytes(ab, 0, ab.length);
        }
        return 0;
    }

    public byte[] readLengthCodedBytes() {
        int count = this.readInt();
        if (count == 0) {
            return new byte[0];
        }
        byte[] bts = new byte[count];
        if (count > this.remaining()) {
            throw new IllegalPacketException("packet content size error: " + count + ">" + this.remaining() + " remaining");
        }
        this.readBytes(bts, 0, count);
        return bts;
    }

    public final String readLengthCodedString(String encoding) {
        int fieldLength = (int)this.readFieldLength();
        if (fieldLength == 0) {
            return null;
        }
        if (fieldLength > this.buffer.remaining()) {
            throw new IllegalPacketException("fieldLength error Buffer.Remaining=" + this.buffer.remaining() + " ,but need size=" + fieldLength);
        }
        byte[] bytes = this.getBytes(fieldLength);
        try {
            if (encoding != null) {
                return new String(bytes, encoding);
            }
            return new String(bytes);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public String toString() {
        return StringUtil.dumpAsHex(this.buffer.array(), this.getPosition());
    }

    public String toSuperString() {
        return super.toString();
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    public abstract void writeFieldLength(int var1);

    public final void writeFloat(float f) {
        this.ensureCapacity(8);
        this.buffer.putFloat(f);
    }

    public final float readFloat() {
        return this.buffer.getFloat();
    }

    public final void writeInt(int i) {
        this.ensureCapacity(4);
        this.buffer.putInt(i);
    }

    public final void writeLengthCodedString(String s, String encoding) {
        if (s != null) {
            byte[] b;
            try {
                b = s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                b = s.getBytes();
            }
            this.ensureCapacity(b.length + 9);
            this.writeFieldLength(b.length);
            this.writeBytes(b);
        } else {
            this.writeFieldLength(0);
        }
    }

    public final void writeLong(long i) {
        this.ensureCapacity(8);
        this.buffer.putLong(i);
    }

    public final void writeString(String s) {
        try {
            this.writeString(s, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public final void writeString(String s, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = null;
        bytes = encoding == null ? s.getBytes() : s.getBytes(encoding);
        this.ensureCapacity(bytes.length + 1 + 8);
        this.writeFieldLength(bytes.length);
        this.writeBytes(bytes);
    }

    public static void main(String[] args) {
        GenericIOPacketBuffer buffer = new GenericIOPacketBuffer(34){

            @Override
            public int getHeadSize() {
                return 0;
            }

            @Override
            public long readFieldLength() {
                return 0L;
            }

            @Override
            public void writeFieldLength(int length) {
            }
        };
        buffer.writeLong(44L);
        ByteBuffer bytbuffer = ByteBuffer.allocate(32);
        bytbuffer.putLong(44L);
        System.out.println(StringUtil.dumpAsHex(bytbuffer.array(), 32));
    }
}

