/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.io;

import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public abstract class PacketOutputStream
extends OutputStream {
    protected ByteBuffer _buffer = ByteBuffer.allocate(32);
    protected static final int INITIAL_BUFFER_SIZE = 32;

    @Override
    public void write(int b) {
        try {
            this._buffer.put((byte)b);
        }
        catch (BufferOverflowException boe) {
            this.expand(1);
            this._buffer.put((byte)b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try {
            this._buffer.put(b, off, len);
        }
        catch (BufferOverflowException boe) {
            this.expand(len);
            this._buffer.put(b, off, len);
        }
    }

    protected final void expand(int needed) {
        int ocapacity = this._buffer.capacity();
        int ncapacity = this._buffer.position() + needed;
        if (ncapacity > ocapacity) {
            ncapacity = Math.max(ocapacity << 1, ncapacity);
            ByteBuffer newbuf = ByteBuffer.allocate(ncapacity);
            newbuf.put((ByteBuffer)this._buffer.flip());
            this._buffer = newbuf;
        }
    }

    public abstract ByteBuffer returnPacketBuffer();

    public void resetPacket() {
        this._buffer.clear();
        this.initHeader();
    }

    public abstract void initHeader();
}

