package com.meidusa.toolkit.net.util;

public interface Queue<T> {

	public abstract void clear();

	public abstract int size();

	public abstract void prepend(T item);

	/**
	 * Appends the supplied item to the end of the queue, and notify a consumer
	 * if and only if the queue was previously empty.
	 */
	public abstract void append(T item);

	/**
	 * Returns the next item on the queue or null if the queue is empty. This
	 * method will not block waiting for an item to be added to the queue.
	 */
	public abstract T getNonBlocking();


}