/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.packet;

import com.meidusa.toolkit.net.packet.PacketBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AbstractPacketBuffer
implements PacketBuffer {
    protected ByteBuffer buffer = null;

    public AbstractPacketBuffer(byte[] buf) {
        this.buffer = ByteBuffer.wrap(buf);
        this.buffer.order(this.getByteOrder());
    }

    public AbstractPacketBuffer(int size) {
        this.buffer = ByteBuffer.allocate(size);
        this.buffer.order(this.getByteOrder());
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        int position = this.getPosition();
        byte[] array = new byte[position];
        this.buffer.position(0);
        this.buffer.get(array, 0, position);
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.rewind();
        this.buffer.position(position);
        return buffer;
    }

    @Override
    public int getPacketLength() {
        return this.buffer.capacity();
    }

    @Override
    public int getPosition() {
        return this.buffer.position();
    }

    @Override
    public void setPosition(int position) {
        if (this.buffer.position() < position) {
            this.ensureCapacity(position - this.buffer.position());
        }
        this.buffer.position(position);
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public byte readByte(int position) {
        this.buffer.position(position);
        return this.buffer.get();
    }

    @Override
    public void writeByte(byte b) {
        this.ensureCapacity(1);
        this.buffer.put(b);
    }

    public void writeShort(short b) {
        this.ensureCapacity(2);
        this.buffer.putShort(b);
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    @Override
    public int writeBytes(byte[] ab) {
        this.ensureCapacity(ab.length);
        return this.writeBytes(ab, 0, ab.length);
    }

    public int writeBytes(byte[] ab, int offset, int len) {
        this.ensureCapacity(len);
        this.buffer.put(ab, offset, len);
        return len;
    }

    @Override
    public int readBytes(byte[] ab, int offset, int len) {
        this.buffer.get(ab, offset, len);
        return len;
    }

    protected void ensureCapacity(int i) {
        if (this.buffer.remaining() < i) {
            int size = this.buffer.capacity() << 1;
            while (size - this.buffer.position() < i) {
                size <<= 1;
            }
            ByteBuffer buffer = ByteBuffer.allocate(size);
            buffer.put((ByteBuffer)this.buffer.flip());
            this.buffer = buffer;
        }
    }

    protected void init() {
    }

    @Override
    public synchronized void reset() {
        this.buffer.rewind();
        this.buffer.position(0);
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public void skip(int bytes) {
        int position = this.buffer.position();
        this.ensureCapacity(bytes);
        this.buffer.position(position + bytes);
    }

    @Override
    public InputStream asInputStream() {
        return new InputStream(){

            @Override
            public int available() {
                return AbstractPacketBuffer.this.remaining();
            }

            @Override
            public int read() {
                if (AbstractPacketBuffer.this.hasRemaining()) {
                    return AbstractPacketBuffer.this.readByte() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                int remaining = AbstractPacketBuffer.this.remaining();
                if (remaining > 0) {
                    int readBytes = Math.min(remaining, len);
                    AbstractPacketBuffer.this.readBytes(b, off, readBytes);
                    return readBytes;
                }
                return -1;
            }

            @Override
            public synchronized void reset() {
                AbstractPacketBuffer.this.reset();
            }

            @Override
            public long skip(long n) {
                int bytes = n > Integer.MAX_VALUE ? AbstractPacketBuffer.this.remaining() : Math.min(AbstractPacketBuffer.this.remaining(), (int)n);
                AbstractPacketBuffer.this.skip(bytes);
                return bytes;
            }
        };
    }

    @Override
    public OutputStream asOutputStream() {
        return new OutputStream(){

            @Override
            public void write(byte[] b, int off, int len) {
                AbstractPacketBuffer.this.writeBytes(b, off, len);
            }

            @Override
            public void write(int b) {
                AbstractPacketBuffer.this.writeByte((byte)b);
            }
        };
    }

    public void writeFixedLengthString(String string, String encoding, int length) {
        if (string == null) {
            this.writeBytes(new byte[length]);
        } else {
            byte[] strBytes = null;
            if (encoding != null) {
                try {
                    strBytes = string.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    strBytes = string.getBytes();
                }
            } else {
                strBytes = string.getBytes();
            }
            if (length <= strBytes.length) {
                this.writeBytes(strBytes, 0, length);
            } else {
                this.writeBytes(strBytes);
                this.writeBytes(new byte[length - strBytes.length]);
            }
        }
    }

    public String readFixedLengthString(String encoding, int length) {
        if (length > this.remaining()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] strBytes = new byte[length];
        this.readBytes(strBytes, 0, length);
        int nullIndex = -1;
        int noNullLength = 0;
        for (int i = strBytes.length - 1; i >= 0; --i) {
            if (strBytes[i] == 0) continue;
            nullIndex = i;
            break;
        }
        if (nullIndex == 0) {
            return null;
        }
        noNullLength = nullIndex == -1 ? length : nullIndex + 1;
        if (encoding == null) {
            return new String(strBytes, 0, noNullLength);
        }
        try {
            return new String(strBytes, 0, noNullLength, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(strBytes, 0, noNullLength);
        }
    }

    public static void main(String[] args) {
        byte[] byts = new byte[]{1, 0, 0, 0, 12, 1, 0, 0};
        AbstractPacketBuffer buffer = new AbstractPacketBuffer(byts);
        String ms = buffer.readFixedLengthString(null, 7);
        System.out.println(ms);
    }
}

