/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public abstract class PacketInputStream
extends InputStream {
    protected ByteBuffer _buffer;
    protected int _length = -1;
    protected int _have = 0;
    protected int _unReadLength = 0;
    protected static final int INITIAL_BUFFER_CAPACITY = 32;
    protected static int MAX_BUFFER_CAPACITY = Integer.getInteger("tookit.packet.max", 0x200000);
    private byte[] tmp = new byte[4096];

    public PacketInputStream() {
        this._buffer = ByteBuffer.allocate(32);
    }

    public boolean readPacket(ReadableByteChannel source) throws IOException {
        if (this._buffer.limit() == this._length) {
            this._buffer.limit(this._have);
            this._buffer.position(this._length);
            this._buffer.compact();
            this._have -= this._length;
            this._length = this.decodeLength();
        }
        if (this.checkForCompletePacket()) {
            return true;
        }
        do {
            int got;
            if ((got = source.read(this._buffer)) == -1) {
                throw new EOFException();
            }
            this._have += got;
            this._unReadLength += got;
            if (this._length == -1) {
                this._length = this.decodeLength();
            }
            if (this._length < -1 || this._length > MAX_BUFFER_CAPACITY) {
                throw new IOException("over max packet limit");
            }
            if (this._buffer.remaining() > 0 || this._length > 0 && this._have >= this._length) break;
            int newSize = this._buffer.capacity() << 1;
            newSize = newSize > this._length ? newSize : this._length + 16;
            ByteBuffer newbuf = ByteBuffer.allocate(newSize);
            newbuf.put((ByteBuffer)this._buffer.flip());
            this._buffer = newbuf;
        } while (this._buffer.capacity() < MAX_BUFFER_CAPACITY);
        return this.checkForCompletePacket();
    }

    public boolean readPacket(InputStream source) throws IOException {
        if (this._buffer.limit() == this._length) {
            this._buffer.limit(this._have);
            this._buffer.position(this._length);
            this._buffer.compact();
            this._have -= this._length;
            this._length = this.decodeLength();
        }
        if (this.checkForCompletePacket()) {
            return true;
        }
        do {
            int got = source.read(this.tmp);
            this.expandCapacity(got);
            if (got == 0) {
                return false;
            }
            if (got > 0) {
                this._buffer.put(this.tmp, 0, got);
            }
            if (got == -1) {
                throw new EOFException();
            }
            this._have += got;
            this._unReadLength += got;
            if (this._length == -1) {
                this._length = this.decodeLength();
            }
            if (this._length >= -1 && this._length <= MAX_BUFFER_CAPACITY) continue;
            throw new IOException("over max packet limit");
        } while (this._buffer.capacity() < MAX_BUFFER_CAPACITY && !this.checkForCompletePacket());
        return true;
    }

    private void expandCapacity(int needSize) {
        if (this._buffer.remaining() < needSize) {
            int newSize = this._buffer.capacity() << 1;
            newSize = newSize > this._length ? newSize : this._length + 16;
            ByteBuffer newbuf = ByteBuffer.allocate(newSize > needSize ? newSize : needSize);
            newbuf.put((ByteBuffer)this._buffer.flip());
            this._buffer = newbuf;
        }
    }

    protected abstract int decodeLength();

    protected boolean checkForCompletePacket() {
        if (this._length == -1 || this._have < this._length || this._length < this.getHeaderSize()) {
            return false;
        }
        this._buffer.position(this.getHeaderSize());
        this._buffer.limit(this._length);
        return true;
    }

    @Override
    public int read() {
        int read = 0;
        try {
            int remaining = this._buffer.remaining();
            if (remaining > 0) {
                read = 1;
            }
            int n = remaining > 0 ? this._buffer.get() & 0xFF : -1;
            return n;
        }
        finally {
            this._unReadLength -= read;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) {
        try {
            if (len == 0) {
                return 0;
            }
            if ((len = Math.min(len, this._buffer.remaining())) == 0) {
                return -1;
            }
            this._buffer.get(b, off, len);
            int n = len;
            return n;
        }
        finally {
            this._unReadLength -= len;
        }
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() {
        return this._buffer.remaining();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public int getLength() {
        return this._length;
    }

    public int getUnReadLength() {
        return this._unReadLength;
    }

    @Override
    public void mark(int readAheadLimit) {
    }

    @Override
    public void reset() {
        this._buffer.position(this.getHeaderSize());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("buffer:").append(this._buffer).append(",length:").append(this._length).append(",have:").append(this._have);
        return buffer.toString();
    }

    public abstract int getHeaderSize();
}

