/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.authenticate.server;

import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.authenticate.server.AuthResponseData;
import com.meidusa.toolkit.net.authenticate.server.AuthenticateFilter;
import com.meidusa.toolkit.net.util.IPRule;
import com.meidusa.toolkit.net.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.FileWatchdog;
import org.apache.log4j.helpers.LogLog;

public class IPAccessController
implements AuthenticateFilter,
Initialisable {
    protected static Logger logger = Logger.getLogger(IPAccessController.class);
    private static final String DENAY_MESSAGE = "Access denied for ip: '${host}' to amoeba server";
    private boolean isEnabled;
    private String[] ipRule = null;
    private String ipFile;

    public void setIpFile(String ipFile) {
        this.ipFile = ipFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> loadIPRule(File ipFile) {
        ArrayList<String> list = new ArrayList<String>();
        if (!ipFile.exists() && !ipFile.isFile()) {
            this.isEnabled = false;
            return list;
        }
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(ipFile));
                String ipRuleLine = null;
                while ((ipRuleLine = reader.readLine()) != null) {
                    if (StringUtil.isEmpty(ipRuleLine = ipRuleLine.trim()) || ipRuleLine.startsWith("#")) continue;
                    try {
                        IPRule.isAllowIP(new String[]{ipRuleLine}, "127.0.0.1");
                        list.add(ipRuleLine);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("'" + ipRuleLine + "' error:" + e.getMessage() + "  ,this rule disabled"));
                    }
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("ip access control loaded from file:" + ipFile.getAbsolutePath()));
                }
                this.isEnabled = true;
                return list;
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)(" file:" + ipFile + " not found ,ip access control disabled."));
                this.isEnabled = false;
                if (reader == null) return list;
                try {
                    reader.close();
                    return list;
                }
                catch (IOException iOException) {}
                return list;
            }
            catch (IOException e) {
                logger.warn((Object)(" reading file:" + ipFile + " error ,ip access control disabled."));
                this.isEnabled = false;
                if (reader == null) return list;
                try {
                    reader.close();
                    return list;
                }
                catch (IOException iOException) {}
                return list;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean doFilte(AuthingableConnection conn, AuthResponseData rdata) {
        if (this.isEnabled && this.ipRule != null && this.ipRule.length > 0) {
            String ip = conn.getInetAddress().getHostAddress();
            try {
                boolean access = IPRule.isAllowIP(this.ipRule, ip);
                if (!access) {
                    Properties properties = new Properties();
                    properties.setProperty("host", ip);
                    rdata.message = ConfigUtil.filter((String)DENAY_MESSAGE, (Properties)properties);
                }
                return access;
            }
            catch (Exception e) {
                logger.warn((Object)(String.valueOf(ip) + " check access error:"), (Throwable)e);
            }
        }
        return true;
    }

    public void init() throws InitialisationException {
        File file = new File(this.ipFile);
        if (!file.exists() && !file.isFile()) {
            this.isEnabled = false;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("ip access control file not found:" + this.ipFile + ", ip access controller disabled."));
            }
        }
        IPAccessFileWatchdog dog = new IPAccessFileWatchdog(this.ipFile);
        dog.setDaemon(true);
        dog.setDelay(60000L);
        dog.start();
    }

    private class IPAccessFileWatchdog
    extends FileWatchdog {
        public IPAccessFileWatchdog(String filename) {
            super(filename);
        }

        public void doOnChange() {
            List list = IPAccessController.this.loadIPRule(new File(this.filename));
            if (list != null) {
                IPAccessController.this.ipRule = list.toArray(new String[list.size()]);
            } else {
                IPAccessController.this.ipRule = null;
            }
            LogLog.warn((String)("ip access config load completed from file:" + this.filename));
        }
    }
}

