/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.io.PacketInputStream;
import com.meidusa.toolkit.net.io.PacketOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public abstract class BIOConnection {
    protected long _lastEvent;
    private Socket socket;
    protected boolean closePosted = false;
    private PacketInputStream _fin;
    protected long lastMessageSent = System.currentTimeMillis();
    private PacketOutputStream _fout;

    public BIOConnection(Socket socket, long createStamp) {
        this._lastEvent = createStamp;
        this.socket = socket;
    }

    protected abstract PacketInputStream createPacketInputStream();

    protected abstract PacketOutputStream createPacketOutputStream();

    protected PacketOutputStream getPacketOutputStream() {
        if (this._fout == null) {
            this._fout = this.createPacketOutputStream();
            this._fout.initHeader();
        }
        return this._fout;
    }

    public void setSoTimeout(int soTimeout) throws SocketException {
        this.socket.setSoTimeout(soTimeout);
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    protected PacketInputStream getPacketInputStream() {
        if (this._fin == null) {
            this._fin = this.createPacketInputStream();
        }
        return this._fin;
    }

    public void write(byte[] bts) throws IOException {
        try {
            this.socket.getOutputStream().write(bts);
        }
        catch (IOException e) {
            this.socket.close();
            throw e;
        }
    }

    public byte[] read() throws IOException {
        boolean isCompleted = false;
        byte[] msg = null;
        try {
            do {
                if (!(isCompleted = this.getPacketInputStream().readPacket(this.socket.getInputStream()))) continue;
                int bytesIn = 0;
                bytesIn = this.getPacketInputStream().available();
                msg = new byte[bytesIn];
                this._fin.read(msg);
            } while (!isCompleted);
        }
        catch (IOException e) {
            this.socket.close();
            throw e;
        }
        return msg;
    }

    public void close() throws Exception {
        this.socket.close();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }
}

