/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.AuthenContext;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.authenticate.server.AuthResponseData;
import com.meidusa.toolkit.net.authenticate.server.AuthenticateProvider;
import com.meidusa.toolkit.net.packet.AbstractPacket;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AuthingableConnection
extends Connection
implements MessageHandler,
AuthenContext {
    private static Logger logger = Logger.getLogger(AuthingableConnection.class);
    protected boolean authenticated;
    private boolean authenticatedSeted = false;
    private int authingTimeout = 5000;
    private Object authenticatLock = new Object();
    private Map<Integer, AbstractPacket> authenContext = new HashMap<Integer, AbstractPacket>(2);
    private AuthenticateProvider authenticateProvider;
    private String lastError;

    public AuthingableConnection(SocketChannel channel, long createStamp) {
        super(channel, createStamp);
    }

    @Override
    public MessageHandler getMessageHandler() {
        if (this.isAuthenticated()) {
            return super.getMessageHandler();
        }
        return this;
    }

    public AuthenticateProvider getAuthenticateProvider() {
        return this.authenticateProvider;
    }

    public void setAuthenticateProvider(AuthenticateProvider authenticateProvider) {
        this.authenticateProvider = authenticateProvider;
    }

    public int getAuthingTimeout() {
        return this.authingTimeout;
    }

    public void setAuthingTimeout(int authingTimeout) {
        this.authingTimeout = authingTimeout;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isAuthenticatedSeted() {
        return this.authenticatedSeted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticated(boolean authenticated) {
        Object object = this.authenticatLock;
        synchronized (object) {
            this.authenticatedSeted = true;
            this.authenticated = authenticated;
            this.authenticatLock.notifyAll();
        }
    }

    protected void beforeAuthing() {
    }

    public void afterAuthing(AuthResponseData data) {
        if (data.code == 0) {
            this.setAuthenticated(true);
            this.connectionAuthenticateSuccess(data);
        } else {
            this.setAuthenticated(false);
            this.connectionAuthenticateFaild(data);
        }
    }

    protected void connectionAuthenticateSuccess(AuthResponseData data) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Connection Authenticate success conn=" + this.getId() + ",hashCode=" + this.hashCode()));
        }
        this.afterAuthenticate();
    }

    protected void connectionAuthenticateFaild(AuthResponseData data) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Connection Authenticate faild conn=" + this.getId() + ",hashCode=" + this.hashCode()));
        }
        this.afterAuthenticate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticatedWithBlocked(long timeout) {
        Object object = this.authenticatLock;
        synchronized (object) {
            if (this.authenticatedSeted) {
                return this.authenticated;
            }
            try {
                this.authenticatLock.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.authenticatedSeted) {
                logger.warn((Object)("authenticate to server:" + this.getId() + " time out"));
            }
            return this.authenticated;
        }
    }

    @Override
    public void putStep(int step, AbstractPacket packet) {
        this.authenContext.put(step, packet);
    }

    @Override
    public AbstractPacket getStep(int step) {
        return this.authenContext.get(step);
    }

    @Override
    public void afterAuthenticate() {
        this.authenContext.clear();
    }
}

