package com.meidusa.toolkit.net;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

import com.meidusa.toolkit.net.io.PacketInputStream;
import com.meidusa.toolkit.net.io.PacketOutputStream;

public abstract class BIOConnection {
	protected long _lastEvent;
	private Socket socket;
	
	protected boolean           closePosted   = false;
    private PacketInputStream   _fin;
    protected long lastMessageSent = System.currentTimeMillis();
    private PacketOutputStream  _fout;

    
    
	public BIOConnection(Socket socket, long createStamp) {
		_lastEvent = createStamp;
		this.socket = socket;
	}
	
    protected abstract PacketInputStream createPacketInputStream();

    protected abstract PacketOutputStream createPacketOutputStream();

    protected PacketOutputStream getPacketOutputStream() {
        if (_fout == null) {
            _fout = createPacketOutputStream();
            _fout.initHeader();
        }
        return this._fout;

    }
    
    public void setSoTimeout(int soTimeout) throws SocketException{
    	this.socket.setSoTimeout(soTimeout);
    	
    }

    public int getSoTimeout() throws SocketException{
    	return socket.getSoTimeout();
    }
    
    protected PacketInputStream getPacketInputStream() {
        if (_fin == null) {
            _fin = createPacketInputStream();
        }
        return this._fin;
    }
    
    public void write(byte[] bts) throws IOException{
    	try{
    		socket.getOutputStream().write(bts);
    	}catch(IOException e){
    		this.socket.close();
    		throw e;
    	}
    }
    
    public byte[] read() throws IOException{
    	boolean isCompleted = false;
    	byte[] msg = null;
    	try{
	    	do{
	    		isCompleted = this.getPacketInputStream().readPacket(this.socket.getInputStream());
	    		if(isCompleted){
	    			int bytesIn = 0;
	    			/**
	    			 * õFramedInputStream ֽ
	    			 */
	    			bytesIn = this.getPacketInputStream().available();
	    			msg = new byte[bytesIn];
	    			_fin.read(msg);
	    		}
	    	}
	    	while(!isCompleted);
    	}catch(IOException e){
    		this.socket.close();
    		throw e;
    	}
    	
    	return msg;
    }
    
    public void close() throws Exception{
    	socket.close();
    }
    
    public boolean isClosed(){
    	return socket.isClosed();
    }
}
