/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.benchmark.util;

import com.meidusa.toolkit.benchmark.util.DocumentUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ObjectMapLoader {
    private static final String PROPS_DTD_URI = "http://amoeba.meidusa.com/objectMap.dtd";
    private static final String PROPS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT bean ( property* ) ><!ATTLIST bean class NMTOKEN #REQUIRED ><!ELEMENT entry ( #PCDATA | bean )* ><!ATTLIST entry key NMTOKEN #REQUIRED ><!ELEMENT objectMap ( entry+ ) ><!ATTLIST objectMap version NMTOKEN #REQUIRED ><!ELEMENT property ( #PCDATA ) ><!ATTLIST property name NMTOKEN #REQUIRED >";

    public static void load(Map<String, Object> props, InputStream in) throws IOException, InvalidPropertiesFormatException {
        Document doc = null;
        try {
            doc = ObjectMapLoader.getLoadingDoc(in);
        }
        catch (SAXException saxe) {
            throw new InvalidPropertiesFormatException(saxe);
        }
        Element propertiesElement = (Element)doc.getChildNodes().item(1);
        ObjectMapLoader.importMap(props, propertiesElement);
    }

    static Document getLoadingDoc(InputStream in) throws SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setValidating(false);
        dbf.setCoalescing(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new Resolver());
            db.setErrorHandler(new EH());
            InputSource is = new InputSource(in);
            return db.parse(is);
        }
        catch (ParserConfigurationException x) {
            throw new Error(x);
        }
    }

    private static void importMap(Map<String, Object> props, Element propertiesElement) {
        int start;
        NodeList entries = propertiesElement.getChildNodes();
        int numEntries = entries.getLength();
        int i = start = numEntries > 0 && entries.item(0).getNodeName().equals("comment") ? 1 : 0;
        while (i < numEntries) {
            Element entry = (Element)entries.item(i);
            if (entry.hasAttribute("key")) {
                Node n = entry.getFirstChild();
                try {
                    Object val = ObjectMapLoader.loadBean(entry);
                    props.put(entry.getAttribute("key"), val);
                }
                catch (Exception e) {
                    throw new Error(e.getMessage(), e);
                }
            }
            ++i;
        }
    }

    private static Object loadBean(Element keyElement) throws Exception {
        NodeList entries = keyElement.getChildNodes();
        int i = 0;
        while (i < entries.getLength()) {
            Node node = entries.item(i);
            if (node instanceof Element) {
                Element entry = (Element)node;
                return DocumentUtil.loadBeanConfig(entry).createBeanObject(true, (Map)System.getProperties());
            }
            ++i;
        }
        String value = keyElement.getTextContent().trim();
        return Class.forName(value).newInstance();
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ObjectMapLoader.load(map, new FileInputStream(new File("c:/1.xml")));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            System.out.println("key=" + entry.getKey() + ",value=" + entry.getValue());
        }
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        @Override
        public void error(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void fatalError(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void warning(SAXParseException x) throws SAXException {
            throw x;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (sid.equals(ObjectMapLoader.PROPS_DTD_URI)) {
                InputSource is = new InputSource(new StringReader(ObjectMapLoader.PROPS_DTD));
                is.setSystemId(ObjectMapLoader.PROPS_DTD_URI);
                return is;
            }
            throw new SAXException("Invalid system identifier: " + sid);
        }
    }
}

