/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.benchmark.util;

import com.meidusa.toolkit.common.bean.config.BeanObjectEntityConfig;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import com.meidusa.toolkit.common.util.StringUtil;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentUtil {
    public static Element getTheOnlyElement(Element current, String tagName) {
        NodeList nodeList = current.getElementsByTagName(tagName);
        if (nodeList.getLength() > 1) {
            throw new ConfigurationException(String.valueOf(tagName) + " elements length  over one!");
        }
        if (nodeList.getLength() == 1) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static BeanObjectEntityConfig loadBeanConfig(Element current) throws Exception {
        if (current == null) {
            return null;
        }
        BeanObjectEntityConfig beanConfig = new BeanObjectEntityConfig();
        NodeList children = current.getChildNodes();
        int childSize = children.getLength();
        beanConfig.setName(current.getAttribute("name"));
        Element element = DocumentUtil.getTheOnlyElement(current, "className");
        if (element != null) {
            beanConfig.setBeanClass(Class.forName(element.getTextContent()));
        } else {
            beanConfig.setBeanClass(Class.forName(current.getAttribute("class")));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < childSize) {
            Element child;
            String nodeName;
            Node childNode = children.item(i);
            if (childNode instanceof Element && (nodeName = (child = (Element)childNode).getNodeName()).equals("property")) {
                String key = child.getAttribute("name");
                NodeList propertyNodes = child.getElementsByTagName("bean");
                if (propertyNodes.getLength() == 0) {
                    String value = child.getTextContent();
                    map.put(key, StringUtil.isEmpty((String)value) ? null : value.trim());
                } else {
                    BeanObjectEntityConfig beanconfig = DocumentUtil.loadBeanConfig((Element)propertyNodes.item(0));
                    map.put(key, (String)beanconfig);
                }
            }
            ++i;
        }
        if (map.get("name") == null) {
            map.put("name", beanConfig.getName());
        }
        beanConfig.setParams(map);
        return beanConfig;
    }
}

