/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.benchmark.util;

import com.meidusa.toolkit.benchmark.util.OptionType;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class CmdLineParser {
    String name;
    private Format format = new Format();
    private String[] remainingArgs = null;
    private List<Option<?>> optionList = new ArrayList();
    private Hashtable<String, Option> options = new Hashtable(10);
    private Hashtable values = new Hashtable(10);

    public CmdLineParser(String applicationName) {
        this.name = applicationName;
    }

    public final Option<?> addOption(Option<?> opt) {
        if (opt.shortForm() != null) {
            this.options.put("-" + opt.shortForm(), opt);
        }
        this.options.put("--" + opt.longForm(), opt);
        this.optionList.add(opt);
        if (opt.longForm() != null) {
            int n = this.format.fullLenght = this.format.fullLenght < opt.longForm().length() ? opt.longForm().length() : this.format.fullLenght;
        }
        if (opt.getDescription() != null) {
            this.format.descriptionLenght = this.format.descriptionLenght < opt.getDescription().length() ? opt.getDescription().length() : this.format.descriptionLenght;
        }
        return opt;
    }

    public List<Option<?>> getOptions() {
        return this.optionList;
    }

    public Option<?> getOption(String name) {
        return this.options.get("--" + name);
    }

    public final Option addOption(OptionType type, char shortForm, String longForm, boolean requried, String description) {
        Option option = null;
        switch (type) {
            case String: {
                option = new StringOption(shortForm, longForm, true);
                break;
            }
            case Int: {
                option = new IntegerOption(shortForm, longForm, true);
                break;
            }
            case Long: {
                option = new LongOption(shortForm, longForm, true);
                break;
            }
            case Double: {
                option = new DoubleOption(shortForm, longForm, true);
                break;
            }
            case Boolean: {
                option = new BooleanOption(shortForm, longForm, true);
            }
        }
        option.setDescription(description);
        option.wantsValue = requried;
        return this.addOption(option);
    }

    public final Option addOption(OptionType type, char shortForm, String longForm, boolean requried, String description, String defaultValue) {
        Option option = this.addOption(type, shortForm, longForm, requried, description);
        option.setDefaultValue(defaultValue);
        return option;
    }

    public final Object getOptionValue(Option o) {
        return this.getOptionValue(o, o.getDefaultValue());
    }

    public Object getOptionValue(Option o, Object def) {
        Vector v = (Vector)this.values.get(o.longForm());
        if (v == null) {
            return def;
        }
        if (v.isEmpty()) {
            return o.getDefaultValue();
        }
        Object result = v.elementAt(0);
        v.removeElementAt(0);
        return result == null ? def : result;
    }

    public final Vector getOptionValues(Option option) {
        Vector<Object> result = new Vector<Object>();
        Object o;
        while ((o = this.getOptionValue(option, null)) != null) {
            result.addElement(o);
        }
        return result;
    }

    public final String[] getRemainingArgs() {
        return this.remainingArgs;
    }

    public final void parse(String[] argv) throws IllegalOptionValueException, UnknownOptionException {
        this.parse(argv, Locale.getDefault());
    }

    public final void parse(String[] argv, Locale locale) throws IllegalOptionValueException, UnknownOptionException {
        Vector<String> otherArgs = new Vector<String>();
        int position = 0;
        this.values = new Hashtable(10);
        while (position < argv.length) {
            String curArg = argv[position];
            if (curArg.startsWith("-")) {
                Option opt;
                if (curArg.equals("--")) {
                    ++position;
                    break;
                }
                String valueArg = null;
                if (curArg.startsWith("--")) {
                    int equalsPos = curArg.indexOf("=");
                    if (equalsPos != -1) {
                        valueArg = curArg.substring(equalsPos + 1);
                        curArg = curArg.substring(0, equalsPos);
                    }
                } else if (curArg.length() > 2) {
                    int i = 1;
                    while (i < curArg.length()) {
                        Option opt2 = this.options.get("-" + curArg.charAt(i));
                        if (opt2 == null) {
                            throw new UnknownSuboptionException(curArg, curArg.charAt(i));
                        }
                        if (opt2.wantsValue()) {
                            throw new NotFlagException(curArg, new String("" + curArg.charAt(i)));
                        }
                        this.addValue(opt2, opt2.getValue(null, locale));
                        ++i;
                    }
                    ++position;
                    continue;
                }
                if ((opt = this.options.get(curArg)) == null) {
                    throw new UnknownOptionException(curArg);
                }
                Object value = null;
                if (opt.wantsValue()) {
                    if (valueArg == null && ++position < argv.length) {
                        valueArg = argv[position];
                    }
                    value = opt.getValue(valueArg, locale);
                } else {
                    value = opt.getValue(null, locale);
                }
                this.addValue(opt, value);
                ++position;
                continue;
            }
            otherArgs.addElement(curArg);
            ++position;
        }
        while (position < argv.length) {
            otherArgs.addElement(argv[position]);
            ++position;
        }
        this.remainingArgs = new String[otherArgs.size()];
        otherArgs.copyInto(this.remainingArgs);
    }

    public void checkRequired() throws NotFlagException {
        for (Option<?> option : this.optionList) {
            Object obj;
            if (!option.isRequired() || (obj = this.values.get(((Option)option).longForm)) != null) continue;
            throw new NotFlagException(((Option)option).longForm, ((Option)option).shortForm);
        }
    }

    private void addValue(Option opt, Object value) {
        String lf = opt.longForm();
        Vector<Object> v = (Vector<Object>)this.values.get(lf);
        if (v == null) {
            v = new Vector<Object>();
            this.values.put(lf, v);
        }
        v.addElement(value);
    }

    public void printUsage() {
        try {
            BufferedWriter writer = new BufferedWriter(new PrintWriter(System.out));
            writer.write(this.name);
            writer.write(" [-option value/--option=value]");
            writer.newLine();
            for (Option<?> option : this.optionList) {
                writer.write("    ");
                writer.write(String.valueOf(!StringUtil.isEmpty((String)option.shortForm()) ? "-" + option.shortForm() + "," : "") + "--" + option.longForm() + (option.wantsValue() ? "=value" : "") + (option.isRequired() ? " [required]" : ""));
                if (option.getDescription() != null) {
                    BufferedReader read = new BufferedReader(new StringReader(option.getDescription()));
                    String line = null;
                    while ((line = read.readLine()) != null) {
                        writer.newLine();
                        writer.write("        ");
                        writer.write(line);
                    }
                }
                writer.newLine();
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class BooleanOption
    extends Option<Boolean> {
        public BooleanOption(char shortForm, String longForm, boolean wantsValue, boolean requried, Boolean defaultValue, String description) {
            super(shortForm, longForm, wantsValue);
            this.setDefaultValue(defaultValue);
            this.setDescription(description);
            this.setRequired(requried);
        }

        public BooleanOption(char shortForm, String longForm, boolean wantsValue, boolean requried, String description) {
            this(shortForm, longForm, wantsValue, requried, null, description);
        }

        public BooleanOption(char shortForm, String longForm, boolean wantsValue, boolean requried) {
            this(shortForm, longForm, wantsValue, requried, null);
        }

        public BooleanOption(char shortForm, String longForm, boolean wantsValue) {
            this(shortForm, longForm, wantsValue, true);
        }

        public BooleanOption(String longForm) {
            super(longForm, true);
        }

        @Override
        protected Boolean parseValue(String arg, Locale locale) throws IllegalOptionValueException {
            return Boolean.parseBoolean(arg);
        }
    }

    public static class DoubleOption
    extends Option<Double> {
        public DoubleOption(char shortForm, String longForm, boolean wantsValue, boolean required, Double defaultValue, String description) {
            super(shortForm, longForm, wantsValue);
            this.setDefaultValue(defaultValue);
            this.setDescription(description);
            this.setRequired(required);
        }

        public DoubleOption(char shortForm, String longForm, boolean wantsValue, boolean required, String description) {
            this(shortForm, longForm, wantsValue, required, null, description);
        }

        public DoubleOption(char shortForm, String longForm, boolean wantsValue, boolean required) {
            this(shortForm, longForm, wantsValue, required, null);
        }

        public DoubleOption(char shortForm, String longForm, boolean wantsValue) {
            this(shortForm, longForm, wantsValue, true);
        }

        public DoubleOption(String longForm) {
            super(longForm, true);
        }

        @Override
        protected Double parseValue(String arg, Locale locale) throws IllegalOptionValueException {
            try {
                NumberFormat format = NumberFormat.getNumberInstance(locale);
                Number num = format.parse(arg);
                return new Double(num.doubleValue());
            }
            catch (ParseException e) {
                throw new IllegalOptionValueException(this, arg);
            }
        }
    }

    class Format {
        int fullLenght;
        int descriptionLenght;

        Format() {
        }
    }

    public static class IllegalOptionValueException
    extends OptionException {
        private static final long serialVersionUID = 1L;
        private Option option;
        private String value;

        public IllegalOptionValueException(Option opt, String value) {
            super("Illegal value '" + value + "' for option " + (opt.shortForm() != null ? "-" + opt.shortForm() + "/" : "") + "--" + opt.longForm());
            this.option = opt;
            this.value = value;
        }

        public Option getOption() {
            return this.option;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class IntegerOption
    extends Option<Integer> {
        public IntegerOption(char shortForm, String longForm, boolean wantsValue, boolean requried, Integer defaultValue, String description) {
            super(shortForm, longForm, wantsValue);
            this.setDefaultValue(defaultValue);
            this.setDescription(description);
            this.setRequired(requried);
        }

        public IntegerOption(char shortForm, String longForm, boolean wantsValue, boolean requried, String description) {
            this(shortForm, longForm, wantsValue, requried, null, description);
        }

        public IntegerOption(char shortForm, String longForm, boolean wantsValue, boolean requried) {
            this(shortForm, longForm, wantsValue, requried, null);
        }

        public IntegerOption(char shortForm, String longForm, boolean wantsValue) {
            this(shortForm, longForm, wantsValue, true);
        }

        public IntegerOption(String longForm) {
            super(longForm, true);
        }

        @Override
        protected Integer parseValue(String arg, Locale locale) throws IllegalOptionValueException {
            try {
                return new Integer(arg);
            }
            catch (NumberFormatException e) {
                throw new IllegalOptionValueException(this, arg);
            }
        }
    }

    public static class LongOption
    extends Option<Long> {
        public LongOption(char shortForm, String longForm, boolean wantsValue, boolean required, Long defaultValue, String description) {
            super(shortForm, longForm, wantsValue);
            this.setDefaultValue(defaultValue);
            this.setDescription(description);
            this.setRequired(required);
        }

        public LongOption(char shortForm, String longForm, boolean wantsValue, boolean required, String description) {
            this(shortForm, longForm, wantsValue, required, null, description);
        }

        public LongOption(char shortForm, String longForm, boolean wantsValue, boolean required) {
            this(shortForm, longForm, wantsValue, required, null);
        }

        public LongOption(char shortForm, String longForm, boolean wantsValue) {
            this(shortForm, longForm, wantsValue, true);
        }

        public LongOption(String longForm) {
            super(longForm, true);
        }

        @Override
        protected Long parseValue(String arg, Locale locale) throws IllegalOptionValueException {
            try {
                return new Long(arg);
            }
            catch (NumberFormatException e) {
                throw new IllegalOptionValueException(this, arg);
            }
        }
    }

    public static class NotFlagException
    extends UnknownOptionException {
        private static final long serialVersionUID = 1L;
        private String notflag;

        NotFlagException(String option, String unflaggish) {
            super(option, "Illegal option: '" + option + "', '" + unflaggish + "' requires a value");
            this.notflag = unflaggish;
        }

        public String getOptionChar() {
            return this.notflag;
        }
    }

    public static abstract class Option<T> {
        private String shortForm = null;
        private String longForm = null;
        private boolean wantsValue = true;
        private boolean required = false;
        private String description;
        private T defaultValue = null;

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        protected Option(String longForm, boolean wantsValue) {
            this(null, longForm, wantsValue);
        }

        protected Option(char shortForm, String longForm, boolean wantsValue) {
            this(shortForm > '\u0000' ? String.valueOf(shortForm) : null, longForm, wantsValue);
        }

        private Option(String shortForm, String longForm, boolean wantsValue) {
            if (longForm == null) {
                throw new IllegalArgumentException("Null longForm not allowed");
            }
            this.shortForm = shortForm;
            this.longForm = longForm;
            this.wantsValue = wantsValue;
        }

        public String shortForm() {
            return this.shortForm;
        }

        public String longForm() {
            return this.longForm;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean wantsValue() {
            return this.wantsValue;
        }

        public final T getValue(String arg, Locale locale) throws IllegalOptionValueException {
            if (this.wantsValue) {
                if (arg == null) {
                    throw new IllegalOptionValueException(this, "");
                }
            } else if (arg == null) {
                return this.getDefaultValue();
            }
            if (arg != null) {
                arg = (String)ConfigUtil.filter((String)arg);
            }
            return this.parseValue(arg, locale);
        }

        protected T parseValue(String arg, Locale locale) throws IllegalOptionValueException {
            return null;
        }
    }

    public static abstract class OptionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        OptionException(String msg) {
            super(msg);
        }
    }

    public static class StringOption
    extends Option<String> {
        public StringOption(char shortForm, String longForm, boolean wantsValue, boolean required, String defaultValue, String description) {
            super(shortForm, longForm, wantsValue);
            this.setDefaultValue(defaultValue);
            this.setDescription(description);
            this.setRequired(required);
        }

        public StringOption(char shortForm, String longForm, boolean wantsValue, boolean required, String description) {
            this(shortForm, longForm, wantsValue, required, null, description);
        }

        public StringOption(char shortForm, String longForm, boolean wantsValue, boolean required) {
            this(shortForm, longForm, wantsValue, required, null);
        }

        public StringOption(char shortForm, String longForm, boolean wantsValue) {
            this(shortForm, longForm, wantsValue, true);
        }

        public StringOption(String longForm) {
            super(longForm, true);
        }

        @Override
        public String getDefaultValue() {
            if (super.getDefaultValue() != null) {
                return (String)ConfigUtil.filter((String)((String)super.getDefaultValue()));
            }
            return (String)super.getDefaultValue();
        }

        @Override
        protected String parseValue(String arg, Locale locale) {
            return arg;
        }
    }

    public static class UnknownOptionException
    extends OptionException {
        private static final long serialVersionUID = 1L;
        private String optionName = null;

        UnknownOptionException(String optionName) {
            this(optionName, "Unknown option '" + optionName + "'");
        }

        UnknownOptionException(String optionName, String msg) {
            super(msg);
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }
    }

    public static class UnknownSuboptionException
    extends UnknownOptionException {
        private static final long serialVersionUID = 1L;
        private char suboption;

        UnknownSuboptionException(String option, char suboption) {
            super(option, "Illegal option: '" + suboption + "' in '" + option + "'");
            this.suboption = suboption;
        }

        public char getSuboption() {
            return this.suboption;
        }
    }
}

