/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.benchmark;

import com.meidusa.toolkit.benchmark.RandomData;
import com.meidusa.toolkit.benchmark.util.MappedByteBufferUtil;
import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class FileLineRandomData
implements RandomData<Object>,
Initialisable {
    private File file;
    private RandomAccessFile raf = null;
    private int size;
    private String lineSplit;
    private boolean needSplit = true;
    private boolean closed = false;
    private MappedByteBuffer buffer = null;
    private String encoding = "gbk";
    private int lineMaxLength = 10240;
    private ThreadLocal<ByteBuffer> localBuffer = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return FileLineRandomData.this.buffer.duplicate();
        }
    };
    private ThreadLocal<ByteBuffer> localTempBuffer = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(FileLineRandomData.this.lineMaxLength);
        }
    };

    public int getLineMaxLength() {
        return this.lineMaxLength;
    }

    public void setLineMaxLength(int lineMaxLength) {
        this.lineMaxLength = lineMaxLength;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isNeedSplit() {
        return this.needSplit;
    }

    public void setNeedSplit(boolean needSplit) {
        this.needSplit = needSplit;
    }

    public String getLineSplit() {
        return this.lineSplit;
    }

    public void setLineSplit(String lineSplit) {
        if (StringUtil.isEmpty((String)lineSplit)) {
            lineSplit = null;
        } else {
            this.lineSplit = lineSplit;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void init() throws InitialisationException {
        try {
            this.raf = new RandomAccessFile(this.file, "r");
            this.size = this.raf.length() > Integer.MAX_VALUE ? Integer.MAX_VALUE : Long.valueOf(this.raf.length()).intValue();
            System.out.println("file size =" + this.size);
            this.buffer = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.size);
            this.buffer.load();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    FileLineRandomData.this.closed = true;
                    MappedByteBufferUtil.unmap(FileLineRandomData.this.buffer);
                    try {
                        FileLineRandomData.this.raf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e);
        }
    }

    @Override
    public Object nextData() {
        if (this.closed) {
            throw new IllegalStateException("file closed..");
        }
        int position = RandomUtils.nextInt((int)(this.size - 1));
        ByteBuffer buffer = this.localBuffer.get();
        this.goNextNewLineHead(buffer, position);
        String[] obj = null;
        String line = this.readLine(buffer);
        if (this.needSplit) {
            obj = this.lineSplit == null ? StringUtils.split((String)line) : StringUtils.split((String)line, (String)this.lineSplit);
            return obj;
        }
        return line;
    }

    private void goNextNewLineHead(ByteBuffer buffer, int position) {
        if (this.closed) {
            throw new IllegalStateException("file closed..");
        }
        buffer.position(position);
        boolean eol = false;
        int c = -1;
        while (!eol) {
            byte by = buffer.get();
            c = by;
            switch (by) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    int cur = buffer.position();
                    if (buffer.get() == 10) break;
                    buffer.position(cur);
                }
            }
            if (eol) continue;
            if (position > 0) {
                buffer.position(--position);
                continue;
            }
            eol = true;
        }
    }

    private final String readLine(ByteBuffer buffer) {
        if (this.closed) {
            throw new IllegalStateException("file closed..");
        }
        ByteBuffer tempbuffer = this.localTempBuffer.get();
        tempbuffer.position(0);
        tempbuffer.limit(tempbuffer.capacity());
        byte c = -1;
        boolean eol = false;
        block6: while (!eol) {
            byte by = buffer.get();
            c = by;
            switch (by) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    int cur = buffer.position();
                    if (buffer.get() == 10) continue block6;
                    buffer.position(cur);
                    break;
                }
                default: {
                    tempbuffer.put(c);
                }
            }
        }
        if (c == -1 && tempbuffer.position() == 0) {
            return null;
        }
        tempbuffer.flip();
        try {
            return new String(tempbuffer.array(), this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(tempbuffer.array());
        }
    }

    public static void main(String[] args) throws Exception {
        FileLineRandomData mapping = new FileLineRandomData();
        mapping.setFile(new File("c:/role.txt"));
        mapping.init();
        ArrayList<4> list = new ArrayList<4>();
        long start = System.currentTimeMillis();
        int j = 0;
        while (j < 1) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < 1000) {
                        System.out.println(((String[])FileLineRandomData.this.nextData())[1]);
                        ++i;
                    }
                }
            };
            list.add(thread);
            thread.start();
            ++j;
        }
        int i = 0;
        while (i < list.size()) {
            ((Thread)list.get(i)).join();
            ++i;
        }
        System.out.println("time=" + (System.currentTimeMillis() - start));
    }
}

