/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.benchmark;

import com.meidusa.toolkit.benchmark.RandomData;
import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.util.StringUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class FileLineData
implements RandomData<Object>,
Initialisable {
    private File file;
    private RandomAccessFile raf = null;
    private String lineSplit;
    private boolean needSplit = true;
    private boolean closed = false;

    public boolean isNeedSplit() {
        return this.needSplit;
    }

    public void setNeedSplit(boolean needSplit) {
        this.needSplit = needSplit;
    }

    public String getLineSplit() {
        return this.lineSplit;
    }

    public void setLineSplit(String lineSplit) {
        if (StringUtil.isEmpty((String)lineSplit)) {
            lineSplit = null;
        } else {
            this.lineSplit = lineSplit;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void init() throws InitialisationException {
        try {
            this.raf = new RandomAccessFile(this.file, "r");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    FileLineData.this.closed = true;
                    try {
                        FileLineData.this.raf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e);
        }
    }

    @Override
    public synchronized Object nextData() {
        if (this.closed) {
            throw new IllegalStateException("file closed..");
        }
        String line = null;
        try {
            line = this.raf.readLine();
            while (StringUtil.isEmpty((String)line) && line != null) {
                line = this.raf.readLine();
            }
            if (line == null) {
                throw new EOFException("end of File=" + this.getFile().getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.closed = true;
            throw new IllegalStateException(e);
        }
        String[] obj = null;
        if (this.needSplit) {
            obj = this.lineSplit == null ? StringUtils.split((String)line) : StringUtils.split((String)line, (String)this.lineSplit);
            return obj;
        }
        return line;
    }

    public static void main(String[] args) throws Exception {
        FileLineData mapping = new FileLineData();
        mapping.setFile(new File("c:/role.txt"));
        mapping.init();
        ArrayList<2> list = new ArrayList<2>();
        long start = System.currentTimeMillis();
        int j = 0;
        while (j < 1) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < 1000) {
                        System.out.println(FileLineData.this.nextData());
                        ++i;
                    }
                }
            };
            list.add(thread);
            thread.start();
            ++j;
        }
        int i = 0;
        while (i < list.size()) {
            ((Thread)list.get(i)).join();
            ++i;
        }
        System.out.println("time=" + (System.currentTimeMillis() - start));
    }
}

