/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.benchmark;

import com.meidusa.toolkit.benchmark.util.CmdLineParser;

public class CmdLineParserTest {
    protected static CmdLineParser parser = new CmdLineParser(System.getProperty("application", "benchmark"));
    protected static CmdLineParser.Option debugOption = parser.addOption(new CmdLineParser.BooleanOption('d', "debug", false, false, true, "show the interaction with the server-side information"));
    protected static CmdLineParser.Option userOption = parser.addOption(new CmdLineParser.StringOption('u', "user", true, true, "root", "mysql user name"));
    protected static CmdLineParser.Option passwordOption = parser.addOption(new CmdLineParser.StringOption('P', "password", true, false, null, "mysql password"));
    protected static CmdLineParser.Option sqlOption = parser.addOption(new CmdLineParser.StringOption('s', "sql", true, false, null, "query sql"));
    protected static CmdLineParser.Option helpOption = parser.addOption(new CmdLineParser.BooleanOption('?', "help", false, false, false, "Show this help message"));

    public static void main(String[] args) {
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            parser.printUsage();
            System.exit(2);
        }
        if (Boolean.TRUE.equals(parser.getOptionValue(helpOption))) {
            parser.printUsage();
            System.exit(0);
        }
        Boolean verboseValue = (Boolean)parser.getOptionValue(debugOption);
        String nameValue = (String)parser.getOptionValue(sqlOption);
        System.out.println("verbose: " + verboseValue);
        System.out.println("sql: " + nameValue);
        String[] otherArgs = parser.getRemainingArgs();
        System.out.println("remaining args: ");
        int i = 0;
        while (i < otherArgs.length) {
            System.out.println(otherArgs[i]);
            ++i;
        }
        System.exit(0);
    }
}

