/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.benchmark;

import com.meidusa.toolkit.benchmark.AbstractBenchmark;
import com.meidusa.toolkit.benchmark.BenchmarkContext;
import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.packet.Packet;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBenchmarkClient<T extends Packet, V extends BenchmarkContext>
implements MessageHandler,
Delayed {
    private static Logger logger = LoggerFactory.getLogger(AbstractBenchmarkClient.class);
    private long lastSentTime = System.currentTimeMillis();
    private boolean debug = false;
    private int timeout = -1;
    private Properties properties;
    long min = System.nanoTime();
    long start = 0L;
    long max = 0L;
    long end = this.min;
    long next = this.min;
    long count = 0L;
    private AbstractBenchmark benchmark;
    private Connection connection;
    protected V context;
    private MessageHandler connOldMessageHandler = null;

    public AbstractBenchmark getBenchmark() {
        return this.benchmark;
    }

    public void setBenchmark(AbstractBenchmark benchmark) {
        this.benchmark = benchmark;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void putAllRequestProperties(Map source) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.putAll((Map<?, ?>)source);
    }

    public Properties getRequestProperties() {
        return this.properties;
    }

    public AbstractBenchmarkClient(Connection connection, V context) {
        this.connection = connection;
        this.start = System.nanoTime();
        this.context = context;
        this.connOldMessageHandler = connection.getMessageHandler();
        connection.setMessageHandler((MessageHandler)this);
    }

    public Map<String, Object> getNextRequestContextMap() {
        return this.benchmark.getNextRequestContextMap();
    }

    public abstract T createRequestPacket();

    public abstract T decodeRecievedPacket(byte[] var1);

    public void startBenchmark() {
        this.postPacketToServer();
    }

    protected void afterMessageRecieved(byte[] message) {
    }

    protected void doReceiveMessage(byte[] message) {
        boolean completed = this.responseIsCompleted(message);
        if (this.debug) {
            try {
                T t = this.decodeRecievedPacket(message);
                System.out.println("<<-- " + t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.afterMessageRecieved(message);
        if (completed) {
            this.end = System.nanoTime();
            long current = this.end - this.next;
            this.next = this.end;
            this.min = Math.min(this.min, current);
            this.max = Math.max(this.max, current);
            ++this.count;
            this.afterResponseCompleted();
        }
    }

    public void afterTimeout() {
        this.postPacketToServer();
    }

    public void handleMessage(Connection conn, byte[] message) {
        if (conn instanceof AuthingableConnection) {
            if (!((AuthingableConnection)conn).isAuthenticated()) {
                this.connOldMessageHandler.handleMessage(conn, message);
            } else {
                this.doReceiveMessage(message);
            }
        } else {
            this.connOldMessageHandler.handleMessage(conn, message);
        }
    }

    protected boolean responseIsCompleted(byte[] message) {
        return true;
    }

    protected void afterResponseCompleted() {
        ((BenchmarkContext)this.context).getResponseLatcher().countDown();
        if (((BenchmarkContext)this.context).isRunning() && ((BenchmarkContext)this.context).getRequestLatcher().getCount() > 0L) {
            ((BenchmarkContext)this.context).getRequestLatcher().countDown();
            this.postPacketToServer();
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.getTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == this) {
            return 0;
        }
        AbstractBenchmarkClient x = (AbstractBenchmarkClient)o;
        long diff = this.lastSentTime - x.lastSentTime;
        if (diff < 0L) {
            return -1;
        }
        return 1;
    }

    protected boolean checkTimeOut() {
        if (this.getTimeout() > 0) {
            long time = TimeUnit.SECONDS.convert(System.currentTimeMillis() - this.lastSentTime, TimeUnit.MILLISECONDS);
            return time > (long)this.getTimeout();
        }
        return false;
    }

    protected void postPacketToServer() {
        T packet = this.createRequestPacket();
        ByteBuffer buffer = packet.toByteBuffer();
        if (this.debug) {
            System.out.println("--->> " + packet);
        }
        this.lastSentTime = System.currentTimeMillis();
        this.connection.postMessage(buffer);
    }

    public void init() {
    }
}

