/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.benchmark;

import com.meidusa.toolkit.benchmark.AbstractBenchmarkClient;
import com.meidusa.toolkit.benchmark.BenchmarkContext;
import com.meidusa.toolkit.benchmark.RandomData;
import com.meidusa.toolkit.benchmark.util.CmdLineParser;
import com.meidusa.toolkit.benchmark.util.ObjectMapLoader;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.net.AbstractConnectionFactory;
import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.ConnectionFactory;
import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.ConnectionObserver;
import com.meidusa.toolkit.net.MultiConnectionManagerWrapper;
import com.meidusa.toolkit.net.NetEventHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.util.Log4jConfigurer;

public abstract class AbstractBenchmark {
    private static AbstractBenchmark benckmark;
    private static Properties properties;
    protected static CmdLineParser parser;
    protected static CmdLineParser.Option debugOption;
    protected static CmdLineParser.Option portOption;
    protected static CmdLineParser.Option hostOption;
    protected static CmdLineParser.Option connOption;
    protected static CmdLineParser.Option totalOption;
    protected static CmdLineParser.Option timeoutOption;
    protected static CmdLineParser.Option contextOption;
    protected static CmdLineParser.Option requestOption;
    protected static CmdLineParser.Option connModelption;
    protected static CmdLineParser.Option bufferOption;
    protected static CmdLineParser.Option log4jOption;
    protected static CmdLineParser.Option helpOption;
    private static Map<String, RandomData> randomMap;
    private static Map contextMap;
    private List<AbstractBenchmarkClient> benchmarkClientList = Collections.synchronizedList(new ArrayList());
    private ConnectionManager connManager;
    private static AtomicLong timeOutCount;

    static {
        properties = new Properties();
        parser = new CmdLineParser(System.getProperty("application", "benchmark"));
        debugOption = parser.addOption(new CmdLineParser.BooleanOption('d', "debug", false, false, true, "show the interaction with the server-side information"));
        portOption = parser.addOption(new CmdLineParser.IntegerOption('P', "port", true, true, "server port"));
        hostOption = parser.addOption(new CmdLineParser.StringOption('h', "host", true, true, "127.0.0.1", "server host"));
        connOption = parser.addOption(new CmdLineParser.IntegerOption('c', "conn", true, true, "The number of concurrent connections"));
        totalOption = parser.addOption(new CmdLineParser.LongOption('n', "total", true, true, "total requests"));
        timeoutOption = parser.addOption(new CmdLineParser.IntegerOption('t', "timeout", true, false, -1, "query timeout, default value=-1 "));
        contextOption = parser.addOption(new CmdLineParser.StringOption('C', "context", true, false, "Context xml File"));
        requestOption = parser.addOption(new CmdLineParser.StringOption('f', "file", true, false, "request xml File"));
        connModelption = parser.addOption(new CmdLineParser.BooleanOption('m', "model", true, false, false, "only connect model"));
        bufferOption = parser.addOption(new CmdLineParser.IntegerOption('b', "buffer", true, false, 64, "socket buffer size"));
        log4jOption = parser.addOption(new CmdLineParser.StringOption('l', "log4j", true, false, "warn", "log4j level[debug,info,warn,error]"));
        helpOption = parser.addOption(new CmdLineParser.BooleanOption('?', "help", false, false, true, "Show this help message"));
        randomMap = new HashMap<String, RandomData>();
        contextMap = new HashMap(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object put(Object key, Object value) {
                if (value instanceof RandomData) {
                    randomMap.put((String)key, (RandomData)value);
                }
                super.put(key, value);
                return value;
            }
        };
        timeOutCount = new AtomicLong(0L);
    }

    protected static void setBenchmark(AbstractBenchmark benckmark) {
        AbstractBenchmark.benckmark = benckmark;
    }

    public List<AbstractBenchmarkClient> getBenchmarkClientList() {
        return this.benchmarkClientList;
    }

    public CmdLineParser getCmdLineParser() {
        return parser;
    }

    public AbstractBenchmark() {
        String contextFile;
        Random random = new Random();
        contextMap.put("random", random);
        contextMap.put("atomicInteger", new AtomicInteger());
        contextMap.put("atomicLong", new AtomicLong());
        String requestXml = (String)parser.getOptionValue(requestOption);
        if (requestXml != null) {
            File reqestXmlFile = new File(requestXml);
            if (reqestXmlFile.exists() && reqestXmlFile.isFile()) {
                try {
                    properties.loadFromXML(new FileInputStream(reqestXmlFile));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            } else {
                System.err.println("requestFile not found or is not file :" + reqestXmlFile.getAbsolutePath());
                System.exit(-1);
            }
        }
        if ((contextFile = (String)parser.getOptionValue(contextOption)) != null) {
            File contextXmlFile = new File(contextFile);
            if (contextXmlFile.exists() && contextXmlFile.isFile()) {
                try {
                    ObjectMapLoader.load(contextMap, new FileInputStream(contextXmlFile));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            } else {
                System.err.println("requestFile not found or not file :" + contextXmlFile.getAbsolutePath());
                System.exit(-1);
            }
        }
    }

    public abstract ConnectionFactory getConnectionFactory();

    public ConnectionManager getConnManager() {
        return this.connManager;
    }

    public void setConnManager(ConnectionManager connManager) {
        this.connManager = connManager;
    }

    public Map<String, Object> getNextRequestContextMap() {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        temp.putAll(contextMap);
        for (Map.Entry<String, RandomData> entry : randomMap.entrySet()) {
            Object obj = null;
            while ((obj = (Object)entry.getValue().nextData()) == null) {
            }
            temp.put(entry.getKey(), obj);
        }
        return temp;
    }

    public static AbstractBenchmark getInstance() {
        return benckmark;
    }

    public abstract AbstractBenchmarkClient newBenchmarkClient(Connection var1, BenchmarkContext var2);

    public static void main(String[] args) throws Exception {
        String level = (String)parser.getOptionValue(log4jOption);
        if (level != null) {
            System.setProperty("benchmark.level", level);
        } else {
            System.setProperty("benchmark.level", "warn");
        }
        final Boolean value = (Boolean)parser.getOptionValue(debugOption, false);
        String logbackConf = System.getProperty("logback.configurationFile", "${project.home}/conf/logback.xml");
        logbackConf = ConfigUtil.filter((String)logbackConf, (Properties)System.getProperties());
        File logbackFile = new File(logbackConf);
        if (logbackFile.exists()) {
            System.out.println("Log system load configuration form " + logbackConf);
            System.setProperty("logback.configurationFile", logbackConf);
        } else {
            String log4jConf = System.getProperty("log4j.configuration", "${project.home}/conf/log4j.xml");
            File log4jFile = new File(log4jConf = ConfigUtil.filter((String)log4jConf, (Properties)System.getProperties()));
            if (!log4jFile.exists()) {
                log4jConf = System.getProperty("log4j.configuration", "${project.home}/conf/log4j.properties");
                log4jConf = ConfigUtil.filter((String)log4jConf, (Properties)System.getProperties());
                log4jFile = new File(log4jConf);
            }
            if (log4jFile.exists()) {
                try {
                    System.setProperty("log4j.configuration", log4jConf);
                    System.out.println("Log system load configuration form " + log4jConf);
                    Log4jConfigurer.initLogging((String)log4jConf, (long)30000L);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        final int conn = (Integer)parser.getOptionValue(connOption);
        final long total = (Long)parser.getOptionValue(totalOption);
        String ip = parser.getOptionValue(hostOption).toString();
        final BenchmarkContext context = new BenchmarkContext((int)total);
        final CountDownLatch reportLatcher = new CountDownLatch(1);
        final AtomicLong errorNum = new AtomicLong(0L);
        int port = (Integer)parser.getOptionValue(portOption);
        final MultiConnectionManagerWrapper manager = new MultiConnectionManagerWrapper();
        manager.addConnectionObserver(new ConnectionObserver(){

            public void connectionClosed(Connection conn) {
                if (value.booleanValue()) {
                    System.out.println(new Date() + "     client conn=" + conn.getId() + " closed!");
                }
            }

            public void connectionEstablished(Connection conn) {
                if (value.booleanValue()) {
                    System.out.println(new Date() + "    client conn=" + conn.getId() + " connected!");
                }
            }

            public void connectionFailed(Connection conn, Exception fault) {
                if (value.booleanValue()) {
                    System.out.println(new Date() + "    client conn=" + conn.getId() + " faild!! " + (fault != null ? " fault=" + fault.getMessage() : ""));
                }
                if (conn instanceof AuthingableConnection) {
                    AuthingableConnection authConn = (AuthingableConnection)conn;
                    if (authConn.isAuthenticatedSeted() && authConn.isAuthenticated()) {
                        errorNum.incrementAndGet();
                    }
                } else {
                    errorNum.incrementAndGet();
                }
            }
        });
        final Integer timeout = (Integer)parser.getOptionValue(timeoutOption, -1);
        if (timeout > 0) {
            manager.setIdleCheckTime((long)timeout.intValue());
        }
        manager.init();
        manager.start();
        Thread.sleep(100L);
        System.out.println("Connection manager started....");
        final CountDownLatch createLatch = new CountDownLatch(conn);
        final CountDownLatch startCreateLatch = new CountDownLatch(1);
        Boolean model = (Boolean)parser.getOptionValue(connModelption);
        if (model == null || !model.booleanValue()) {
            new Thread(){
                long lastCount;
                long lastTime;
                {
                    this.lastCount = benchmarkContext.getResponseLatcher().getCount();
                    this.lastTime = System.currentTimeMillis();
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    try {
                        startCreateLatch.await();
                    }
                    catch (InterruptedException interruptedException) {}
                    while (context.getResponseLatcher().getCount() > 0L) {
                        long current = context.getResponseLatcher().getCount();
                        long currentTime = System.currentTimeMillis();
                        long tps = 0L;
                        tps = currentTime > this.lastTime ? (this.lastCount - current) * 1000L / (currentTime - this.lastTime) : this.lastCount - current;
                        this.lastCount = current;
                        this.lastTime = currentTime;
                        System.out.println(new Date() + "    request=" + (total - context.getRequestLatcher().getCount()) + ",  compeleted=" + (total - this.lastCount) + ", errorResult=" + context.errorNum.get() + ", TPS=" + tps + ", timeoutNum=" + timeOutCount.get() + " ,conns=" + manager.getSize());
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (context.getRequestLatcher().getCount() == 0L && context.getResponseLatcher().getCount() - errorNum.get() <= 0L) break;
                    }
                    long i = 0L;
                    while (i < errorNum.get()) {
                        context.getResponseLatcher().countDown();
                        ++i;
                    }
                    System.out.println(new Date() + "    request=" + (total - context.getRequestLatcher().getCount()) + ",  compeleted=" + (total - context.getResponseLatcher().getCount()) + ", errorResult=" + context.errorNum.get() + ", timeoutNum=" + timeOutCount.get() + " ,conns=" + manager.getSize());
                    reportLatcher.countDown();
                }
            }.start();
        } else {
            new Thread(){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    while (createLatch.getCount() > 0L) {
                        System.out.println(new Date() + "     conns=" + manager.getSize());
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    System.out.println(new Date() + "     compeleted=" + conn);
                }
            }.start();
        }
        System.out.println("\r\nconnect to ip=" + ip + ",port=" + port + ",connection size=" + conn + ",total request=" + total);
        final AbstractBenchmark benckmark = AbstractBenchmark.getInstance();
        benckmark.setConnManager((ConnectionManager)manager);
        final ConnectionFactory factory = benckmark.getConnectionFactory();
        Integer bufferSize = (Integer)parser.getOptionValue(bufferOption);
        if (factory instanceof AbstractConnectionFactory) {
            if (bufferSize != null) {
                ((AbstractConnectionFactory)factory).setReceiveBufferSize(bufferSize.intValue());
                ((AbstractConnectionFactory)factory).setSendBufferSize(bufferSize.intValue());
            }
            ((AbstractConnectionFactory)factory).setConnectionManager((ConnectionManager)manager);
        }
        if (factory instanceof Initialisable) {
            ((Initialisable)factory).init();
        }
        final long createConnectionStartTime = System.nanoTime();
        final ExecutorService executor = Executors.newFixedThreadPool(Integer.getInteger("createConnectionThreadSize", Runtime.getRuntime().availableProcessors()));
        final InetSocketAddress address = new InetSocketAddress(ip, port);
        System.out.println("---------------- create connection-----------------");
        startCreateLatch.countDown();
        final AtomicInteger bindError = new AtomicInteger();
        int i = 0;
        while (i < conn) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        SocketChannel channel = null;
                        while (true) {
                            try {
                                channel = SocketChannel.open(address);
                            }
                            catch (BindException e) {
                                int totle = bindError.incrementAndGet();
                                if (totle <= conn) continue;
                                System.err.println("connect to " + address + " error, totle=" + totle);
                                e.printStackTrace();
                                System.exit(-1);
                                continue;
                            }
                            break;
                        }
                        Connection connection = factory.createConnection(channel, System.currentTimeMillis());
                        if (connection.getConnectionManager() == null) {
                            manager.postRegisterNetEventHandler((NetEventHandler)connection, 1);
                        }
                        AbstractBenchmarkClient client = benckmark.newBenchmarkClient(connection, context);
                        client.setBenchmark(benckmark);
                        client.setTimeout(timeout);
                        client.setDebug(value);
                        client.putAllRequestProperties(properties);
                        client.init();
                        if (connection instanceof AuthingableConnection) {
                            AuthingableConnection aconn = (AuthingableConnection)connection;
                            if (aconn.isAuthenticatedWithBlocked(5000L)) {
                                benckmark.benchmarkClientList.add(client);
                            } else {
                                aconn.postClose(null);
                            }
                        } else {
                            benckmark.benchmarkClientList.add(client);
                        }
                        createLatch.countDown();
                    }
                    catch (Exception e) {
                        System.err.println("connect to " + address + " error:");
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
            });
            ++i;
        }
        createLatch.await();
        final long createConnectionEndTime = System.nanoTime();
        System.out.println("---------------- end (" + TimeUnit.MILLISECONDS.convert(createConnectionEndTime - createConnectionStartTime, TimeUnit.NANOSECONDS) + "ms)-----------------");
        if (model != null && model.booleanValue()) {
            return;
        }
        for (AbstractBenchmarkClient client : benckmark.benchmarkClientList) {
            if (context.getRequestLatcher().getCount() <= 0L) continue;
            context.getRequestLatcher().countDown();
            client.startBenchmark();
        }
        new Thread(){
            {
                this.setDaemon(true);
                this.setName("timeout check thread");
            }

            @Override
            public void run() {
                while (context.getResponseLatcher().getCount() > 0L) {
                    ArrayList<AbstractBenchmarkClient> timeOutList = new ArrayList<AbstractBenchmarkClient>();
                    for (AbstractBenchmarkClient client : benckmark.benchmarkClientList) {
                        if (context.getResponseLatcher().getCount() <= 0L || !client.checkTimeOut()) continue;
                        timeOutCount.incrementAndGet();
                        timeOutList.add(client);
                        context.getResponseLatcher().countDown();
                    }
                    for (AbstractBenchmarkClient client : timeOutList) {
                        client.afterTimeout();
                    }
                    timeOutList.clear();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }.start();
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    context.setRunning(false);
                    long endBenchmarkTime = System.nanoTime();
                    if (benckmark.benchmarkClientList.size() == 0) {
                        executor.shutdown();
                        manager.shutdown();
                        return;
                    }
                    long min = ((AbstractBenchmarkClient)((AbstractBenchmark)benckmark).benchmarkClientList.get((int)0)).min;
                    long max = 0L;
                    long minStart = ((AbstractBenchmarkClient)((AbstractBenchmark)benckmark).benchmarkClientList.get((int)0)).start;
                    long maxend = 0L;
                    long average = 0L;
                    int totleConnection = 0;
                    for (AbstractBenchmarkClient connection : benckmark.benchmarkClientList) {
                        if (connection.count <= 0L) continue;
                        min = Math.min(min, connection.min);
                        max = Math.max(max, connection.max);
                        average += (connection.end - connection.start) / connection.count;
                        minStart = Math.min(minStart, connection.start);
                        maxend = Math.max(maxend, connection.end);
                        ++totleConnection;
                    }
                    long time = TimeUnit.MILLISECONDS.convert(maxend - minStart, TimeUnit.NANOSECONDS);
                    try {
                        reportLatcher.await(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long requested = total - context.getResponseLatcher().getCount();
                    System.out.println("completed requests total=" + requested + ", cost=" + TimeUnit.MILLISECONDS.convert(maxend - minStart, TimeUnit.NANOSECONDS) + "ms , TPS=" + (time > 0L ? requested * 1000L / time : requested) + "/s");
                    double thisTime = (double)TimeUnit.MICROSECONDS.convert(min, TimeUnit.NANOSECONDS) / 1000.0;
                    System.out.println("min=" + thisTime + " ms");
                    thisTime = (double)TimeUnit.MICROSECONDS.convert(max, TimeUnit.NANOSECONDS) / 1000.0;
                    System.out.println("max=" + thisTime + " ms");
                    thisTime = (double)TimeUnit.MICROSECONDS.convert(average, TimeUnit.NANOSECONDS) / (double)(totleConnection * 1000);
                    DecimalFormat fmt = new DecimalFormat("#.###");
                    System.out.println("average=" + fmt.format(thisTime) + " ms");
                    System.out.println("timeout Num=" + timeOutCount.get());
                    System.out.println("Error result=" + context.errorNum.get());
                    System.out.println("connection Error Num=" + errorNum.get());
                    System.out.println("create Connections time=" + TimeUnit.MILLISECONDS.convert(createConnectionEndTime - createConnectionStartTime, TimeUnit.NANOSECONDS) + "ms");
                    long tpsTime = TimeUnit.MILLISECONDS.convert(endBenchmarkTime - createConnectionEndTime, TimeUnit.NANOSECONDS);
                    System.out.println("TPS(after connected)=" + (tpsTime > 0L ? requested * 1000L / tpsTime : requested) + "/s");
                    executor.shutdown();
                    manager.shutdown();
                }
            });
        }
        catch (IllegalStateException e) {
            context.setRunning(false);
            executor.shutdown();
            manager.shutdown();
            System.exit(-1);
        }
        context.getRequestLatcher().await();
        context.setRunning(false);
        context.getResponseLatcher().await();
        System.exit(0);
    }
}

