/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultJSONParser;
import com.meidusa.fastjson.parser.Feature;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.JSONScanner;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.parser.deserializer.ASMDeserializerFactory;
import com.meidusa.fastjson.parser.deserializer.ASMJavaBeanDeserializer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class TypeHandleBeanDeserializer
extends ASMJavaBeanDeserializer {
    private String key;
    private HashMap<String, Class<?>> valueClassMapping = new HashMap();
    private ObjectDeserializer defaultAsmJavaBeanDeserializer;
    private boolean isAbstract = false;

    public void addValueClass(String str, Class<?> clazz) {
        this.valueClassMapping.put(str, clazz);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public HashMap<String, Class<?>> getValueClassMapping() {
        return this.valueClassMapping;
    }

    public void setValueClassMapping(HashMap<String, Class<?>> valueClassMapping) {
        this.valueClassMapping = valueClassMapping;
    }

    public TypeHandleBeanDeserializer(ParserConfig mapping, Class<?> clazz) {
        super(mapping, clazz);
        if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
            this.defaultAsmJavaBeanDeserializer = null;
            this.isAbstract = true;
        } else {
            try {
                this.defaultAsmJavaBeanDeserializer = ASMDeserializerFactory.getInstance().createJavaBeanDeserializer(mapping, clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mapping.putDeserializer(clazz, this);
    }

    @Override
    public Object createInstance(DefaultJSONParser parser, Type type) {
        return new Object();
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Class<?> shouldBe;
        String keyStr;
        int j;
        char c;
        int i;
        JSONScanner jsonscanner;
        block10: {
            jsonscanner = (JSONScanner)parser.getLexer();
            i = jsonscanner.getBufferPosition();
            c = jsonscanner.getCurrent();
            j = jsonscanner.token();
            keyStr = null;
            shouldBe = null;
            if (jsonscanner.token() == 8) {
                jsonscanner.nextToken(16);
                return null;
            }
            while (true) {
                String handleStr;
                if ((handleStr = jsonscanner.scanSymbol(parser.getSymbolTable())) == null) {
                    if (jsonscanner.token() == 13) {
                        jsonscanner.nextToken(16);
                        break block10;
                    }
                    if (jsonscanner.token() == 16 && parser.isEnabled(Feature.AllowArbitraryCommas)) continue;
                }
                jsonscanner.nextTokenWithColon();
                Object o = this.skipComplicatedValue(parser, jsonscanner);
                if (o != null && handleStr.equals(this.key)) {
                    keyStr = o.toString();
                    shouldBe = this.valueClassMapping.get(keyStr);
                }
                if (shouldBe != null) break block10;
                if (jsonscanner.token() == 16) continue;
                if (jsonscanner.token() == 13) {
                    jsonscanner.nextToken(16);
                    break block10;
                }
                if (jsonscanner.token() == 18 || jsonscanner.token() == 1) break;
            }
            throw new JSONException("syntax error, unexpect token " + JSONToken.name(jsonscanner.token()));
        }
        jsonscanner.reset(i, c, j);
        if (shouldBe == null) {
            if (this.isAbstract) {
                if (StringUtils.isEmpty((String)keyStr)) {
                    throw new JSONException(this.key + " must be set");
                }
                throw new JSONException(this.key + " is :\"" + keyStr + "\" but it's matching class not found.");
            }
            if (this.defaultAsmJavaBeanDeserializer != null) {
                return this.defaultAsmJavaBeanDeserializer.deserialze(parser, type, fieldName);
            }
            return super.deserialze(parser, type, fieldName);
        }
        return parser.parseObject(shouldBe);
    }

    public Object skipComplicatedValue(DefaultJSONParser parser, JSONLexer lexer) {
        switch (lexer.token()) {
            case 14: {
                int inner = 1;
                lexer.nextToken();
                while (true) {
                    if (lexer.token() == 14) {
                        ++inner;
                    } else if (lexer.token() == 15 && --inner == 0) break;
                    lexer.nextToken();
                }
                lexer.nextToken();
                return null;
            }
            case 12: {
                int inner = 1;
                lexer.nextToken();
                while (true) {
                    if (lexer.token() == 12) {
                        ++inner;
                    } else if (lexer.token() == 13 && --inner == 0) break;
                    lexer.nextToken();
                }
                lexer.nextToken();
                return null;
            }
            case 2: {
                Number intValue = lexer.integerValue();
                lexer.nextToken();
                return intValue;
            }
            case 3: {
                BigDecimal value = lexer.decimalValue();
                lexer.nextToken();
                return value;
            }
            case 4: {
                JSONScanner iso8601Lexer;
                String stringLiteral = lexer.stringVal();
                lexer.nextToken(16);
                if (lexer.isEnabled(Feature.AllowISO8601DateFormat) && (iso8601Lexer = new JSONScanner(stringLiteral)).scanISO8601DateIfMatch()) {
                    return iso8601Lexer.getCalendar().getTime();
                }
                return stringLiteral;
            }
            case 8: {
                lexer.nextToken();
                return null;
            }
            case 6: {
                lexer.nextToken();
                return Boolean.TRUE;
            }
            case 7: {
                lexer.nextToken();
                return Boolean.FALSE;
            }
            case 9: {
                lexer.nextToken(16);
            }
            case 20: {
                if (!lexer.isBlankInput()) break;
                return null;
            }
        }
        throw new JSONException("TODO " + JSONToken.name(lexer.token()) + " " + lexer.stringVal());
    }
}

