package com.meidusa.fastjson.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class DefinedParameterizedType implements ParameterizedType {

	public Class<?> rawType;
	public Type[] actualTypes;
	private Type ownerType;

	@Override
	public Type[] getActualTypeArguments() {
		return actualTypes;
	}

	@Override
	public Type getRawType() {
		return rawType;
	}

	@Override
	public Type getOwnerType() {
		return ownerType;
	}

	public void setRawType(Class<?> rawType) {
		this.rawType = rawType;
	}

	public void setActualTypes(Type[] actualTypes) {
		this.actualTypes = actualTypes;
	}

	public String toString() {
		StringBuilder sb = new StringBuilder();

		if (ownerType != null) {
			if (ownerType instanceof Class)
				sb.append(((Class) ownerType).getName());
			else
				sb.append(ownerType.toString());

			sb.append(".");

			if (ownerType instanceof ParameterizedType) {
				// Find simple name of nested type by removing the
				// shared prefix with owner.
				sb.append(rawType.getName().replace(
						((Class<?>) ((ParameterizedType) ownerType).getRawType()).getName() + "$", ""));
			} else
				sb.append(rawType.getName());
		} else
			sb.append(rawType.getName());

		if (actualTypes != null && actualTypes.length > 0) {
			sb.append("<");
			boolean first = true;
			for (Type t : actualTypes) {
				if (!first)
					sb.append(", ");
				if (t instanceof Class)
					sb.append(((Class) t).getName());
				else
					sb.append(t.toString());
				first = false;
			}
			sb.append(">");
		}

		return sb.toString();
	}

	public void setOwnerType(Type ownerType) {
		this.ownerType = ownerType;
	}

}
