package com.meidusa.fastjson.serializer;

import java.io.IOException;
import java.util.Currency;

import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;


public class CurrencySerializer implements ObjectSerializer {

    public final static CurrencySerializer instance = new CurrencySerializer();

    public void write(JSONSerializer serializer, Object object) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }

        Currency currency = (Currency) object;
        serializer.write(currency.toString());
    }

}
