package com.meidusa.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONToken;

public class HashSetTypeDeserializer implements ObjectDeserializer {

    private Type itemType;

    public HashSetTypeDeserializer(Type type){
        this.itemType = type;
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        Set set = new HashSet();

        parser.parseArray(itemType, set);

        return (T) set;
    }

    public int getFastMatchToken() {
        return JSONToken.LBRACKET;
    }

}
