package com.meidusa.fastjson.parser.deserializer;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;

public abstract class AbstractMapDeserializer implements ObjectDeserializer {
	
	public abstract Map  createMap();

    @SuppressWarnings("unchecked")
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
    	
        final JSONLexer lexer = parser.getLexer();
        if (lexer.token() == JSONToken.NULL) {
            lexer.nextToken(JSONToken.COMMA);
            return null;
        }
       
        Map map = null;
        if(type instanceof ParameterizedType){
            Type rawType = ((ParameterizedType) type).getRawType();
            if(rawType instanceof Class){
                Class clazz = (Class) rawType;
                int modifiers = clazz.getModifiers() ;
                if( (modifiers & Modifier.ABSTRACT) != 0  || (clazz.getModifiers() & Modifier.INTERFACE) != 0){
                    map = createMap();
                }else{
                    map = (Map)PureJavaReflectionProvider.getInstance().newInstance(clazz);
                }
            }
        }else{
            Class clazz = (Class) type;
            int modifiers = clazz.getModifiers() ;
            if( (modifiers & Modifier.ABSTRACT) != 0  || (clazz.getModifiers() & Modifier.INTERFACE) != 0){
                map = createMap();
            }else{
                map = (Map)PureJavaReflectionProvider.getInstance().newInstance(clazz);
            }
        }
        
        
        if(type instanceof ParameterizedType){
        	Type[] actualTypes = ((ParameterizedType) type).getActualTypeArguments();
        	parser.parseObject(map,actualTypes[0],actualTypes[1]);
            return (T) map;
        }else{
            
        	parser.parseObject(map,Object.class);
            return (T) map;
        }
        
    }

    public int getFastMatchToken() {
        return JSONToken.LBRACE;
    }
}
