/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.regex;

import com.meidusa.toolkit.common.util.regex.Perl5CompilerWrapper;
import org.apache.oro.text.regex.MalformedPatternException;

public class PathNameCompiler
extends Perl5CompilerWrapper {
    public static final int FORCE_ABSOLUTE_PATH = 1;
    public static final int FORCE_RELATIVE_PATH = 2;
    public static final int FORCE_MATCH_PREFIX = 4;
    private static final char SLASH = '/';
    private static final char UNDERSCORE = '_';
    private static final char DASH = '-';
    private static final char DOT = '.';
    private static final char STAR = '*';
    private static final char QUESTION = '?';
    private static final String REGEX_MATCH_PREFIX = "^";
    private static final String REGEX_WORD_BOUNDARY = "\\b";
    private static final String REGEX_SLASH = "\\/";
    private static final String REGEX_SLASH_NO_DUP = "\\/(?!\\/)";
    private static final String REGEX_FILE_NAME_CHAR = "[\\w\\-\\.]";
    private static final String REGEX_FILE_NAME_SINGLE_CHAR = "([\\w\\-\\.])";
    private static final String REGEX_FILE_NAME = "([\\w\\-\\.]*)";
    private static final String REGEX_FILE_PATH = "([\\w\\-\\.]+(?:\\/(?!\\/)[\\w\\-\\.]*)*(?=\\/|$)|)\\/?";
    private static final int LAST_TOKEN_START = 0;
    private static final int LAST_TOKEN_SLASH = 1;
    private static final int LAST_TOKEN_FILE_NAME = 2;
    private static final int LAST_TOKEN_STAR = 3;
    private static final int LAST_TOKEN_DOUBLE_STAR = 4;
    private static final int LAST_TOKEN_QUESTION = 5;

    @Override
    public String toPerl5Regex(char[] pattern, int options) throws MalformedPatternException {
        boolean forceRelativePath;
        int lastToken = 0;
        StringBuffer buffer = new StringBuffer(pattern.length * 2);
        boolean forceMatchPrefix = (options & 4) != 0;
        boolean forceAbsolutePath = (options & 1) != 0;
        boolean bl = forceRelativePath = (options & 2) != 0;
        if (forceMatchPrefix || pattern.length > 0 && pattern[0] == '/') {
            buffer.append(REGEX_MATCH_PREFIX);
        }
        int i = 0;
        while (i < pattern.length) {
            char ch = pattern[i];
            if (forceAbsolutePath && lastToken == 0 && ch != '/') {
                throw new MalformedPatternException(this.getDefaultErrorMessage(pattern, i));
            }
            switch (ch) {
                case '/': {
                    if (lastToken == 1) {
                        throw new MalformedPatternException(this.getDefaultErrorMessage(pattern, i));
                    }
                    if (forceRelativePath && lastToken == 0) {
                        throw new MalformedPatternException(this.getDefaultErrorMessage(pattern, i));
                    }
                    if (lastToken != 4) {
                        buffer.append(REGEX_SLASH_NO_DUP);
                    }
                    lastToken = 1;
                    break;
                }
                case '*': {
                    int j = i + 1;
                    if (j < pattern.length && pattern[j] == '*') {
                        i = j;
                        if (lastToken != 0 && lastToken != 1) {
                            throw new MalformedPatternException(this.getDefaultErrorMessage(pattern, i));
                        }
                        lastToken = 4;
                        buffer.append(REGEX_FILE_PATH);
                        break;
                    }
                    if (lastToken == 3 || lastToken == 4) {
                        throw new MalformedPatternException(this.getDefaultErrorMessage(pattern, i));
                    }
                    lastToken = 3;
                    buffer.append(REGEX_FILE_NAME);
                    break;
                }
                case '?': {
                    lastToken = 5;
                    buffer.append(REGEX_FILE_NAME_SINGLE_CHAR);
                    break;
                }
                default: {
                    if (lastToken == 4) {
                        throw new MalformedPatternException(this.getDefaultErrorMessage(pattern, i));
                    }
                    if (Character.isLetterOrDigit(ch) || ch == '_' || ch == '-') {
                        if (lastToken == 0) {
                            buffer.append(REGEX_WORD_BOUNDARY).append(ch);
                        } else if (i + 1 == pattern.length) {
                            buffer.append(ch).append(REGEX_WORD_BOUNDARY);
                        } else {
                            buffer.append(ch);
                        }
                    } else if (ch == '.') {
                        buffer.append('\\').append('.');
                    } else {
                        throw new MalformedPatternException(this.getDefaultErrorMessage(pattern, i));
                    }
                    lastToken = 2;
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

