/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.regex;

import com.meidusa.toolkit.common.util.regex.MatchContext;
import com.meidusa.toolkit.common.util.regex.MatchPattern;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcherInput;

public class MatchItem
implements MatchResult {
    public static final int SUBSTITUTION_ONLY = 0;
    public static final int SUBSTITUTION_WITH_PREMATCH = 1;
    public static final int SUBSTITUTION_WITH_POSTMATCH = 2;
    private MatchContext context;
    private MatchPattern pattern;
    private MatchResult result;

    public MatchItem(MatchContext context, MatchPattern pattern) {
        this.context = context;
        this.pattern = pattern;
    }

    public MatchItem(MatchContext context, MatchPattern pattern, MatchResult result) {
        this(context, pattern);
        this.result = result;
    }

    public MatchContext getMatchContext() {
        return this.context;
    }

    public MatchPattern getMatchPattern() {
        return this.pattern;
    }

    public String getInput() {
        return (String)this.context.getInput().getInput();
    }

    public int length() {
        return this.result == null ? 0 : this.result.length();
    }

    public int groups() {
        return this.result == null ? 0 : this.result.groups();
    }

    public String group(int group) {
        return this.result == null ? null : this.result.group(group);
    }

    public int begin(int group) {
        return this.result == null ? -1 : this.result.begin(group);
    }

    public int end(int group) {
        return this.result == null ? -1 : this.result.end(group);
    }

    public int beginOffset(int group) {
        return this.result == null ? -1 : this.result.beginOffset(group);
    }

    public int endOffset(int group) {
        return this.result == null ? -1 : this.result.endOffset(group);
    }

    public String toString() {
        return this.result == null ? "" : this.result.toString();
    }

    public void appendPreMatch(StringBuffer buffer) {
        PatternMatcherInput input = this.context.getInput();
        char[] inputBuffer = input.getBuffer();
        int beginOffset = input.getBeginOffset();
        buffer.append(inputBuffer, beginOffset, this.beginOffset(0) - beginOffset);
    }

    public void appendPostMatch(StringBuffer buffer) {
        PatternMatcherInput input = this.context.getInput();
        char[] inputBuffer = input.getBuffer();
        int beginOffset = this.endOffset(0);
        buffer.append(inputBuffer, beginOffset, input.length() - beginOffset);
    }

    public void appendMatch(StringBuffer buffer) {
        PatternMatcherInput input = this.context.getInput();
        char[] inputBuffer = input.getBuffer();
        int beginOffset = this.beginOffset(0);
        buffer.append(inputBuffer, beginOffset, this.endOffset(0));
    }

    public void appendSubstitution(StringBuffer buffer, String substitution) {
        this.context.getSubstitution(substitution).appendSubstitution(buffer, (MatchResult)this, 1, this.context.getInput(), this.context.getMatcher(), this.pattern.getPattern());
    }

    public String substitute(String substitution) {
        return this.substitute(substitution, 0);
    }

    public String substitute(String substitution, int options) {
        StringBuffer buffer = new StringBuffer();
        if ((options & 1) != 0) {
            this.appendPreMatch(buffer);
        }
        this.appendSubstitution(buffer, substitution);
        if ((options & 2) != 0) {
            this.appendPostMatch(buffer);
        }
        return buffer.toString();
    }
}

