/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util.regex;

import com.meidusa.toolkit.common.util.collection.Predicate;
import com.meidusa.toolkit.common.util.regex.MatchContext;
import com.meidusa.toolkit.common.util.regex.MatchItem;
import com.meidusa.toolkit.common.util.regex.MatchPattern;
import com.meidusa.toolkit.common.util.regex.MatchStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class BestMatchStrategy
implements MatchStrategy {
    private static final Comparator MATCH_LENGTH_COMPARATOR = new Comparator(){

        public int compare(Object item1, Object item2) {
            return ((MatchItem)item2).length() - ((MatchItem)item1).length();
        }
    };

    @Override
    public boolean matches(MatchContext context) {
        Predicate predicate = context.getPredicate();
        if (predicate == null) {
            return this.matchWithoutPredicate(context);
        }
        Collection patterns = context.getPatterns();
        ArrayList<MatchItem> matchItemList = new ArrayList<MatchItem>(patterns.size());
        for (MatchPattern pattern : patterns) {
            if (!pattern.matches(context)) continue;
            matchItemList.add(context.getLastMatchItem());
        }
        if (matchItemList.size() == 0) {
            return false;
        }
        Collections.sort(matchItemList, MATCH_LENGTH_COMPARATOR);
        for (MatchItem item : matchItemList) {
            if (!predicate.evaluate(item)) continue;
            context.setLastMatchItem(item);
            return true;
        }
        return false;
    }

    private boolean matchWithoutPredicate(MatchContext context) {
        MatchItem bestMatchItem = null;
        int bestMatchLength = -1;
        for (MatchPattern pattern : context.getPatterns()) {
            MatchItem matchItem;
            int matchLength;
            if (!pattern.matches(context) || (matchLength = (matchItem = context.getLastMatchItem()).length()) <= bestMatchLength) continue;
            bestMatchItem = matchItem;
            bestMatchLength = matchLength;
        }
        if (bestMatchItem != null) {
            context.setLastMatchItem(bestMatchItem);
            return true;
        }
        return false;
    }
}

