/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util;

import com.meidusa.toolkit.common.util.URLResourceReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class NetworkClassLoader
extends ClassLoader {
    private ClassLoader parent = null;
    private Hashtable classCache = new Hashtable();
    private Hashtable urlset = new Hashtable();

    public NetworkClassLoader(ClassLoader parent) {
        this.setParent(parent);
    }

    protected final void setParent(ClassLoader parent) {
        this.parent = parent;
    }

    public synchronized void addURL(URL url) {
        if (!this.urlset.containsKey(url)) {
            try {
                this.urlset.put(url, new URLResourceReader(url));
            }
            catch (IOException iOException) {}
        } else {
            try {
                URLResourceReader newu = new URLResourceReader(url);
                URLResourceReader oldu = (URLResourceReader)this.urlset.get(url);
                oldu.close();
                this.urlset.remove(url);
                this.urlset.put(url, newu);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Enumeration getURLs() {
        return this.urlset.keys();
    }

    public Class findClass(String name) {
        byte[] b = this.loadClassData(name);
        if (b == null) {
            return null;
        }
        return this.defineClass(name, b, 0, b.length);
    }

    protected byte[] loadResource(URL url, String resourceName) throws IOException {
        URLResourceReader urr = (URLResourceReader)this.urlset.get(url);
        if (urr != null) {
            return urr.getResource(resourceName);
        }
        return null;
    }

    protected byte[] loadResource(String resource) {
        byte[] barray = null;
        Enumeration e = this.urlset.keys();
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            try {
                try {
                    barray = this.loadResource(url, resource);
                }
                catch (Exception exception) {
                    if (barray == null) continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                if (barray != null) break;
                throw throwable;
            }
            if (barray != null) break;
        }
        return barray;
    }

    protected byte[] loadClassData(String classname) {
        String resourceName = String.valueOf(classname.replace('.', '/')) + ".class";
        return this.loadResource(resourceName);
    }

    @Override
    protected URL findResource(String name) {
        byte[] barray = null;
        Enumeration e = this.urlset.keys();
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            try {
                barray = this.loadResource(url, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (barray == null) continue;
            try {
                String ref = url.toString();
                if (ref.endsWith(".jar")) {
                    return new URL("jar:" + ref + "!/" + name);
                }
                return new URL(url, name);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream istream = null;
        istream = NetworkClassLoader.getSystemResourceAsStream(name);
        if (istream != null) {
            return istream;
        }
        if (this.parent != null && (istream = this.parent.getResourceAsStream(name)) != null) {
            return istream;
        }
        byte[] data = this.loadResource(name);
        if (data != null) {
            istream = new ByteArrayInputStream(data);
        }
        return istream;
    }

    protected Class defineClass(String classname, byte[] classdata) {
        return this.defineClass(classname, classdata, 0, classdata.length);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c;
        block22: {
            block20: {
                c = null;
                try {
                    try {
                        c = this.findSystemClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (c != null) {
                            return c;
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (c != null) {
                        return c;
                    }
                    throw throwable;
                }
                if (c != null) {
                    return c;
                }
            }
            try {
                try {
                    if (this.parent != null) {
                        c = this.parent.loadClass(name);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (c != null) {
                        return c;
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (c != null) {
                    return c;
                }
                throw throwable;
            }
            if (c != null) {
                return c;
            }
        }
        if ((c = (Class)this.classCache.get(name)) != null) {
            return c;
        }
        byte[] data = this.loadClassData(name);
        if (data != null) {
            c = this.defineClass(name, data);
            this.classCache.put(name, c);
            if (resolve) {
                this.resolveClass(c);
            }
        } else {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    public final void clear() {
        this.urlset.clear();
        this.classCache.clear();
    }

    protected void finalize() throws Throwable {
        this.clear();
        this.parent = null;
        this.urlset = null;
        this.classCache = null;
    }
}

