/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.tableformat;

import com.meidusa.toolkit.common.tableformat.AbstractTableFormatter;
import com.meidusa.toolkit.common.tableformat.TableFormatter;
import java.util.ArrayList;

public final class SimpleTableFormatter
extends AbstractTableFormatter
implements TableFormatter {
    private boolean border = false;

    public SimpleTableFormatter() {
    }

    public SimpleTableFormatter(boolean border) {
        this();
        this.border = border;
    }

    @Override
    public int getTableWidth() {
        int width = super.getTableWidth();
        if (this.border) {
            width += 2;
            if (this.getColumnCount() > 1) {
                width += this.getColumnCount() - 1;
            }
        }
        return width;
    }

    @Override
    public int getTableHeight() {
        int height = super.getTableHeight();
        if (this.border) {
            height += 2;
            if (this.getRowCount() > 1) {
                height += this.getRowCount() - 1;
            }
        }
        return height;
    }

    @Override
    public String[] getFormattedRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException("rowIndex");
        }
        int cellHeight = this.getRowHeight(rowIndex);
        ArrayList<StringBuffer> rowLines = new ArrayList<StringBuffer>(cellHeight);
        int i = 0;
        while (i < cellHeight) {
            StringBuffer buffer = new StringBuffer();
            if (this.border) {
                buffer.append('|');
            }
            rowLines.add(buffer);
            ++i;
        }
        if (rowLines.size() != cellHeight) {
            throw new IllegalStateException("rowLines.size()");
        }
        int columnIndex = 0;
        int columnCount = this.getColumnCount();
        while (columnIndex < columnCount) {
            String[] cell = this.getFormattedCell(rowIndex, columnIndex);
            if (cell.length != cellHeight) {
                throw new IllegalStateException("cell.size()");
            }
            int i2 = 0;
            while (i2 < cellHeight) {
                StringBuffer buffer = (StringBuffer)rowLines.get(i2);
                if (columnIndex > 0 && this.border) {
                    buffer.append('|');
                }
                buffer.append(cell[i2]);
                ++i2;
            }
            ++columnIndex;
        }
        if (this.border) {
            i = 0;
            while (i < cellHeight) {
                StringBuffer buffer = (StringBuffer)rowLines.get(i);
                buffer.append('|');
                ++i;
            }
        }
        if (rowLines.size() != cellHeight) {
            throw new IllegalStateException("rowLines.size()");
        }
        ArrayList<String> result = new ArrayList<String>(cellHeight);
        int i3 = 0;
        while (i3 < cellHeight) {
            StringBuffer buffer = (StringBuffer)rowLines.get(i3);
            result.add(buffer.toString());
            ++i3;
        }
        if (result.size() != cellHeight) {
            throw new IllegalStateException("result.size()");
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getFormattedTable() {
        ArrayList<String> result = new ArrayList<String>();
        String borderText = null;
        if (this.border) {
            borderText = this.getFormattedBorder();
            result.add(borderText);
        }
        int rowIndex = 0;
        int rowCount = this.getRowCount();
        while (rowIndex < rowCount) {
            if (rowIndex > 0 && this.border) {
                result.add(borderText);
            }
            String[] row = this.getFormattedRow(rowIndex);
            int i = 0;
            int size = row.length;
            while (i < size) {
                result.add(row[i]);
                ++i;
            }
            ++rowIndex;
        }
        if (this.border) {
            result.add(borderText);
        }
        return result.toArray(new String[result.size()]);
    }

    private String getFormattedBorder() {
        StringBuffer result = new StringBuffer();
        result.append('+');
        int columnIndex = 0;
        int columnCount = this.getColumnCount();
        while (columnIndex < columnCount) {
            if (columnIndex > 0) {
                result.append('+');
            }
            int i = 0;
            while (i < this.getColumnWidth(columnIndex)) {
                result.append('-');
                ++i;
            }
            ++columnIndex;
        }
        result.append('+');
        return result.toString();
    }
}

