/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.spring;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class ChoiceResource
extends AbstractResource
implements InitializingBean {
    private static Logger logger = Logger.getLogger(ChoiceResource.class);
    private List<Resource> choices;
    private String name;
    private Resource selection;

    public List<Resource> getChoices() {
        return this.choices;
    }

    public void setChoices(List<Resource> choices) {
        this.choices = choices;
    }

    public File getFile() throws IOException {
        return this.selection.getFile();
    }

    public String getDescription() {
        return this.selection.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.selection.getInputStream();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.selection.createRelative(relativePath);
    }

    public URL getURL() throws IOException {
        return this.selection.getURL();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.choices == null || this.choices.isEmpty()) {
            throw new InvalidParameterException(String.valueOf(this.getName()) + " parameter choices no values");
        }
        for (Resource resource : this.choices) {
            if (!resource.exists()) continue;
            this.selection = resource;
            break;
        }
        if (this.selection == null) {
            throw new FileNotFoundException(String.valueOf(this.getName()) + " resource not found:all choiced list resource not found");
        }
        logger.info((Object)(String.valueOf(this.getName()) + " choice resource from URL=" + this.getURL()));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

