/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.security;

import com.meidusa.toolkit.common.security.AsymmetricEncrypt;
import com.meidusa.toolkit.common.security.EncryptException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public interface SymmetricEncrypt
extends AsymmetricEncrypt {
    public static final String CIPHER_MODE_PADDING = "/ECB/PKCS5Padding";

    public Key generateKey(String var1) throws Exception;

    public byte[] decrypt(byte[] var1) throws EncryptException;

    public static class SymmetricAlgorithm {
        public static SymmetricAlgorithm DES = new SymmetricAlgorithm("DES", null, null);
        public static SymmetricAlgorithm DESede = new SymmetricAlgorithm("DESede", null, null);
        private static Map<String, SymmetricAlgorithm> symmetricMap = new HashMap<String, SymmetricAlgorithm>();
        private String name;
        private String mode = "ECB";
        private String padding = "PKCS5Padding";

        public static SymmetricAlgorithm valueOf(String name) {
            return symmetricMap.get(name);
        }

        public SymmetricAlgorithm(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SymmetricAlgorithm(String name, String mode, String padding) {
            this(name);
            this.mode = mode;
            this.padding = padding;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getPadding() {
            return this.padding;
        }

        public void setPadding(String padding) {
            this.padding = padding;
        }

        public boolean equals(Object obs) {
            if (!(obs instanceof SymmetricAlgorithm)) {
                return false;
            }
            SymmetricAlgorithm other = (SymmetricAlgorithm)obs;
            boolean equals = StringUtils.equals((String)this.name, (String)other.name);
            equals = equals && StringUtils.equals((String)this.mode, (String)other.mode);
            equals = equals && StringUtils.equals((String)this.padding, (String)other.padding);
            return equals;
        }

        public int hashCode() {
            return 114 + (this.name != null ? this.name.hashCode() : 0) + (this.mode != null ? this.mode.hashCode() : 0) + (this.padding != null ? this.padding.hashCode() : 0);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(this.name);
            if (this.mode != null) {
                buffer.append("/");
                buffer.append(this.mode);
                if (this.padding != null) {
                    buffer.append("/");
                    buffer.append(this.padding);
                }
            }
            return buffer.toString();
        }

        static {
            symmetricMap.put(DES.getName(), DES);
            symmetricMap.put(DESede.getName(), DESede);
        }
    }
}

