/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.security;

import com.meidusa.toolkit.common.security.EncryptException;
import com.meidusa.toolkit.common.security.SymmetricEncrypt;
import java.security.Key;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;

public class BaseSymmetricEncrypt
implements SymmetricEncrypt {
    private Key key;
    private String algorithmModePadding;
    private SymmetricEncrypt.SymmetricAlgorithm algorithm;

    public BaseSymmetricEncrypt(SymmetricEncrypt.SymmetricAlgorithm algorithm, String seed) throws Exception {
        this.algorithm = algorithm;
        this.algorithmModePadding = this.algorithm.toString();
        this.key = this.generateKey(seed);
    }

    @Override
    public Key generateKey(String seed) throws Exception {
        KeySpec keySpec = null;
        if ("DES".equalsIgnoreCase(this.algorithm.getName())) {
            keySpec = new DESKeySpec(seed.getBytes("utf-8"));
        } else if ("DESede".equalsIgnoreCase(this.algorithm.getName())) {
            keySpec = new DESedeKeySpec(seed.getBytes("utf-8"));
        }
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.algorithmModePadding);
        SecretKey securekey = keyFactory.generateSecret(keySpec);
        return securekey;
    }

    @Override
    public byte[] encrypt(byte[] data) throws EncryptException {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithmModePadding);
            cipher.init(1, this.key);
            byte[] raw = cipher.doFinal(data);
            return raw;
        }
        catch (Exception e) {
            throw new EncryptException("Do encrypt occurs Exception", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] raw) throws EncryptException {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithmModePadding);
            cipher.init(2, this.key);
            byte[] data = cipher.doFinal(raw);
            return data;
        }
        catch (Exception e) {
            throw new EncryptException("Do decrypt occurs Exception.", e);
        }
    }
}

