package com.meidusa.toolkit.common.security;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

public interface SymmetricEncrypt extends AsymmetricEncrypt {
	public static class SymmetricAlgorithm {
		public static SymmetricAlgorithm DES = new SymmetricAlgorithm("DES",null,null);
		public static SymmetricAlgorithm DESede = new SymmetricAlgorithm("DESede",null,null);
		private static Map<String,SymmetricAlgorithm> symmetricMap = new HashMap<String,SymmetricAlgorithm>();
		static{
			symmetricMap.put(DES.getName(), DES);
			symmetricMap.put(DESede.getName(), DESede);
		}
		
		public static SymmetricAlgorithm valueOf(String name){
			return symmetricMap.get(name);
		}
		
		public SymmetricAlgorithm(String name){
			this.name = name;
		}
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public SymmetricAlgorithm(String name,String mode,String padding){
			this(name);
			this.mode = mode;
			this.padding = padding;
		}
		private String name;
		private String mode = "ECB";
		private String padding = "PKCS5Padding";
		public String getMode() {
			return mode;
		}
		public void setMode(String mode) {
			this.mode = mode;
		}
		public String getPadding() {
			return padding;
		}
		public void setPadding(String padding) {
			this.padding = padding;
		}
		
		public boolean equals(Object obs){
			if(!(obs instanceof SymmetricAlgorithm)){
				return false;
			}
			SymmetricAlgorithm other = (SymmetricAlgorithm)obs;
			boolean equals = StringUtils.equals(name, other.name);
			equals = equals && StringUtils.equals(mode, other.mode);
			equals = equals && StringUtils.equals(padding, other.padding);
			return equals;
		}
		public int hashCode(){
			return 114+(name!= null?name.hashCode():0)+(mode!= null?mode.hashCode():0)+(padding!= null?padding.hashCode():0);
		}
		public String toString(){
			StringBuffer buffer = new StringBuffer(name);
			if(mode != null){
				buffer.append("/");
				buffer.append(mode);
				if(padding != null){
					buffer.append("/");
					buffer.append(padding);
				}
			}
			return buffer.toString();
		}
	};
	
	String CIPHER_MODE_PADDING = "/ECB/PKCS5Padding"; 
	/**
	 * ؼ㷨Կڽ״ĹӦöʱ
	 * Կ
	 * @return   Key  ضԳԿ
	 * @throws java.security.NoSuchAlgorithmException
	 * @throws UnsupportedEncodingException 
	 * @throws InvalidKeyException 
	 */
	public abstract Key generateKey(String seed) throws Exception;

	/**
	 * ѼָܵͨԿн
	 * @param key  Կ
	 * @param raw  ܵ
	 * @return   byte[] ܺ
	 */
	public abstract byte[] decrypt(byte[] raw)
			throws EncryptException;

}