package com.meidusa.toolkit.common.security;

import java.security.Key;
import java.security.spec.KeySpec;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;

/**
 * 
 * @author Struct
 *
 */
public class BaseSymmetricEncrypt implements SymmetricEncrypt{
	
	private Key key;
	private String algorithmModePadding;
	private SymmetricAlgorithm algorithm;
	public BaseSymmetricEncrypt(SymmetricAlgorithm algorithm,String seed) throws Exception{
		this.algorithm = algorithm;
		//this.algorithmModePadding = this.algorithm+CIPHER_MODE_PADDING;
		this.algorithmModePadding = this.algorithm.toString();
		key = generateKey(seed);
	}

    /* (non-Javadoc)
	 * @see com.meidusa.toolkit.common.security.Encrypt#getKey(java.lang.String)
	 */
    public Key generateKey(String seed) throws Exception {
       /* KeyGenerator generator = KeyGenerator.getInstance(algorithm);
        try {
			generator.init(new SecureRandom(seed.getBytes("utf-8")));
		} catch (UnsupportedEncodingException e) {
			generator.init(new SecureRandom(seed.getBytes()));
		}
        Key key = generator.generateKey();*/
    	KeySpec keySpec = null;
    	if("DES".equalsIgnoreCase(algorithm.getName())){
    		keySpec = new DESKeySpec(seed.getBytes("utf-8"));
    	}else if("DESede".equalsIgnoreCase(algorithm.getName())){
    		keySpec = new DESedeKeySpec(seed.getBytes("utf-8"));
    	}
		SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithmModePadding);
		SecretKey securekey = keyFactory.generateSecret(keySpec);
		return securekey;
    }

    /* (non-Javadoc)
	 * @see com.meidusa.toolkit.common.security.Encrypt#doEncrypt(java.security.Key, byte[])
	 */
    public byte[] encrypt(byte[] data) throws EncryptException {
        try {
            Cipher cipher = Cipher.getInstance(algorithmModePadding);
            cipher.init(Cipher.ENCRYPT_MODE, key);
            byte[] raw = cipher.doFinal(data);
            return raw;
        } catch (Exception e) {
            throw new EncryptException("Do encrypt occurs Exception",e);
        }
    }

    /* (non-Javadoc)
	 * @see com.meidusa.toolkit.common.security.Encrypt#doDecrypt(java.security.Key, byte[])
	 */
    public byte[] decrypt(byte[] raw) throws EncryptException {
        try {
            Cipher cipher = Cipher.getInstance(algorithmModePadding);
            cipher.init(Cipher.DECRYPT_MODE, key);
            byte[] data = cipher.doFinal(raw);
            return data;
        } catch (Exception e) {
            throw new EncryptException("Do decrypt occurs Exception.",e);
        }
    }
}
