/*
 * Decompiled with CFR 0.152.
 */
package net.sf.corn.cps;

import java.io.Serializable;
import java.net.URL;

public class RootedURL
implements Serializable {
    private static final long serialVersionUID = -4967318289335433478L;
    private URL rootURL = null;
    private URL resourceURL = null;
    private String rootPath = null;
    private String resourcePath = null;
    private String packageName = null;
    private String resourceName = null;
    private String nakedClassName = null;

    public RootedURL(URL rootURL, URL resourceURL) {
        if (rootURL == null) {
            throw new IllegalArgumentException("Null root URL not accepted!");
        }
        if (resourceURL == null) {
            throw new IllegalArgumentException("Null resource URL not accepted!");
        }
        this.rootPath = rootURL.toString().substring(rootURL.toString().indexOf(":/") + 2);
        this.resourcePath = resourceURL.toString().substring(resourceURL.toString().indexOf(":/") + 2);
        if (!this.resourcePath.startsWith(this.rootPath) && this.rootPath.endsWith("/") && !this.resourcePath.startsWith(this.rootPath.substring(0, this.rootPath.length() - 1))) {
            throw new IllegalArgumentException("The root URL \"" + rootURL + "\" is not root of the resource URL \"" + resourceURL + "\"");
        }
        this.rootURL = rootURL;
        this.resourceURL = resourceURL;
        this.packageName = this.resourcePath;
        this.packageName = this.rootPath.equals(this.packageName) ? "" : (this.packageName.lastIndexOf(47) >= this.rootPath.length() ? this.packageName.substring(this.rootPath.length(), this.packageName.lastIndexOf(47)) : "");
        this.packageName = this.packageName.replace('/', '.');
        if (this.packageName.startsWith(".")) {
            this.packageName = this.packageName.substring(1);
        }
        this.resourceName = this.resourcePath;
        this.resourceName = this.rootPath.equals(this.resourceName) ? null : (this.resourceName.lastIndexOf(47) >= this.rootPath.length() && this.resourceName.length() > this.resourceName.lastIndexOf(47) ? this.resourceName.substring(this.resourceName.lastIndexOf(47) + 1) : null);
        if (this.resourceName != null && this.resourceName.indexOf(".class") > 0) {
            this.nakedClassName = this.resourceName.substring(0, this.resourceName.indexOf(".class"));
        }
    }

    public URL getRootURL() {
        return this.rootURL;
    }

    public URL getResourceURL() {
        return this.resourceURL;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getClassName() {
        return String.valueOf(this.packageName) + "." + this.nakedClassName;
    }

    public String getNakedClassName() {
        return this.nakedClassName;
    }

    public String toString() {
        return "Root:" + this.getRootURL() + ",Resource:" + this.getResourceURL();
    }

    public boolean isArchive() {
        String url = this.rootURL.toString();
        if (url.startsWith("file")) {
            return url.toLowerCase().endsWith("jar") || url.toLowerCase().endsWith("zip");
        }
        if (url.startsWith("vfs")) {
            return url.toLowerCase().endsWith("jar") || url.toLowerCase().endsWith("zip") || url.toLowerCase().endsWith("jar/") || url.toLowerCase().endsWith("zip/");
        }
        if (url.startsWith("jar")) {
            return true;
        }
        return url.toLowerCase().startsWith("jar") || url.toLowerCase().startsWith("zip");
    }
}

