/*
 * Decompiled with CFR 0.152.
 */
package net.sf.corn.cps;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.corn.cps.CPResourceFilter;
import net.sf.corn.cps.NamePattern;
import net.sf.corn.cps.RootedURL;

public class ResourceFilter
implements CPResourceFilter {
    private static final Integer NAME_TYPE_PACKAGE = 1;
    private static final Integer NAME_TYPE_RESOURCE = 2;
    private static final Integer NAME_TYPE_CLASS = 3;
    private static final Integer NAME_TYPE_DIRECTORY = 4;
    private static final Integer NAME_TYPE_ARCHIVE = 5;
    private Map<Integer, Set<NamePattern>> namePatterns = new HashMap<Integer, Set<NamePattern>>();
    private boolean scanArchives = true;

    private ResourceFilter appendName(String name, int type) {
        if (this.namePatterns.get(type) == null) {
            this.namePatterns.put(type, new HashSet());
        }
        this.namePatterns.get(type).add(new NamePattern(name));
        return this;
    }

    public ResourceFilter packageName(String name) {
        return this.appendName(name, NAME_TYPE_PACKAGE);
    }

    public ResourceFilter resourceName(String name) {
        return this.appendName(name, NAME_TYPE_RESOURCE);
    }

    public ResourceFilter archiveName(String name) {
        return this.appendName(name, NAME_TYPE_ARCHIVE);
    }

    public ResourceFilter directoryName(String name) {
        return this.appendName(name, NAME_TYPE_DIRECTORY);
    }

    public ResourceFilter scanArchives(boolean scan) {
        this.scanArchives = scan;
        return this;
    }

    public ResourceFilter className(String name) {
        return this.appendName(name, NAME_TYPE_CLASS);
    }

    @Override
    public boolean accept(Object subject) {
        if (!this.filterable(subject)) {
            return true;
        }
        return !(subject instanceof RootedURL ? !this.checkRootedURL((RootedURL)subject) : subject instanceof URL && !this.checkURL((URL)subject));
    }

    private boolean checkURL(URL url) {
        boolean matched;
        if (this.isArchive(url)) {
            if (!this.scanArchives) {
                return false;
            }
            if (this.namePatterns.get(NAME_TYPE_ARCHIVE) != null && this.namePatterns.get(NAME_TYPE_ARCHIVE).size() > 0) {
                String archiveName = this.extractArchiveName(url);
                matched = false;
                for (NamePattern namePattern : this.namePatterns.get(NAME_TYPE_ARCHIVE)) {
                    if (!namePattern.matches(archiveName)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return false;
                }
            }
        }
        if (this.namePatterns.get(NAME_TYPE_DIRECTORY) != null && this.namePatterns.get(NAME_TYPE_DIRECTORY).size() > 0) {
            String dirName = this.extractDirName(url);
            matched = false;
            for (NamePattern np : this.namePatterns.get(NAME_TYPE_DIRECTORY)) {
                if (!np.matches(dirName)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return false;
            }
        }
        return true;
    }

    private String extractDirName(URL url) {
        String st = url.toExternalForm();
        if (this.isArchive(url)) {
            int inx = st.indexOf(".jar");
            if (inx < 0) {
                inx = st.indexOf(".zip");
            }
            if (inx > 0) {
                st = st.substring(0, inx - 1);
            }
            if ((inx = st.lastIndexOf("/")) > 0) {
                st = st.substring(0, inx - 1);
            }
        }
        if (st.contains(":/")) {
            st = st.substring(st.indexOf(":/") + 2);
        }
        return !st.endsWith("/") ? st : st.substring(0, st.length() - 1);
    }

    private String extractArchiveName(URL url) {
        String st = url.toExternalForm();
        int inx = st.indexOf(".jar");
        if (inx < 0) {
            inx = st.indexOf(".zip");
        }
        if (inx < 0) {
            return "";
        }
        int binx = st.lastIndexOf("/", inx);
        binx = binx < 0 ? 0 : ++binx;
        return st.substring(binx, inx + 4);
    }

    private boolean isArchive(URL url) {
        String urlStr = url.toString();
        if (urlStr.startsWith("file")) {
            return urlStr.toLowerCase().endsWith(".jar") || urlStr.toLowerCase().endsWith(".zip");
        }
        if (urlStr.startsWith("vfs")) {
            return urlStr.toLowerCase().endsWith(".jar") || urlStr.toLowerCase().endsWith(".zip") || urlStr.toLowerCase().endsWith(".jar/") || urlStr.toLowerCase().endsWith(".zip/");
        }
        return urlStr.toLowerCase().startsWith("jar") || urlStr.toLowerCase().startsWith("zip");
    }

    private boolean checkRootedURL(RootedURL rootedUrl) {
        boolean matched = false;
        if (this.namePatterns.get(NAME_TYPE_PACKAGE) != null && this.namePatterns.get(NAME_TYPE_PACKAGE).size() > 0) {
            matched = false;
            for (NamePattern np : this.namePatterns.get(NAME_TYPE_PACKAGE)) {
                if (!np.matches(rootedUrl.getPackageName())) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return false;
            }
        }
        if (this.namePatterns.get(NAME_TYPE_RESOURCE) != null && this.namePatterns.get(NAME_TYPE_RESOURCE).size() > 0) {
            if (rootedUrl.getResourceName() == null) {
                return false;
            }
            matched = false;
            for (NamePattern np : this.namePatterns.get(NAME_TYPE_RESOURCE)) {
                if (!np.matches(rootedUrl.getResourceName())) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return false;
            }
        }
        if (this.namePatterns.get(NAME_TYPE_CLASS) != null && this.namePatterns.get(NAME_TYPE_CLASS).size() > 0) {
            if (rootedUrl.getNakedClassName() == null) {
                return false;
            }
            matched = false;
            for (NamePattern np : this.namePatterns.get(NAME_TYPE_CLASS)) {
                if (!np.matches(rootedUrl.getNakedClassName())) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean filterable(Object subject) {
        return subject != null && (subject instanceof RootedURL || subject instanceof URL);
    }

    public String toString() {
        return "ResourceFilter [namePatterns=" + this.namePatterns + ", scanArchives=" + this.scanArchives + "]";
    }
}

