/*
 * Decompiled with CFR 0.152.
 */
package net.sf.corn.cps;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NamePattern {
    static final Integer NAME_TYPE_PACKAGE = 1;
    static final Integer NAME_TYPE_RESOURCE = 2;
    static final Integer NAME_TYPE_CLASS = 3;
    static final Integer NAME_TYPE_DIRECTORY = 4;
    static final Integer NAME_TYPE_ARCHIVE = 5;
    private static final Pattern GRAB_SP_CHARS = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
    private Pattern pattern;
    private boolean negative;

    NamePattern(String name) {
        this.negative = name.startsWith("!");
        String ptrn = this.negative ? NamePattern.prepName(name.substring(1)) : NamePattern.prepName(name);
        this.pattern = Pattern.compile(ptrn);
    }

    Pattern getPattern() {
        return this.pattern;
    }

    boolean isNegative() {
        return this.negative;
    }

    boolean matches(String name) {
        if (this.pattern.matcher(name).matches()) {
            return !this.negative;
        }
        return this.negative;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.negative ? 1231 : 1237);
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamePattern other = (NamePattern)obj;
        if (this.negative != other.negative) {
            return false;
        }
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }

    private static String escapeRE(String str) {
        if (str == null) {
            return str;
        }
        Matcher match = GRAB_SP_CHARS.matcher(str);
        return match.replaceAll("\\\\$1");
    }

    private static String prepName(String name) {
        return NamePattern.escapeRE(name.replace("*", "##-##")).replace("##-##", ".*").replace("_", ".");
    }

    public String toString() {
        return "NamePattern [negative=" + this.negative + ",pattern=" + this.pattern + "]";
    }
}

