/*
 * Decompiled with CFR 0.152.
 */
package net.sf.corn.cps;

import java.util.HashSet;
import java.util.Set;
import net.sf.corn.cps.CPResourceFilter;

public class CombinedFilter
implements CPResourceFilter {
    private boolean combineWithOr = true;
    private Set<CPResourceFilter> filters = new HashSet<CPResourceFilter>();

    @Override
    public boolean accept(Object subject) {
        for (CPResourceFilter filter : this.filters) {
            if (!filter.filterable(subject)) continue;
            if (this.combineWithOr) {
                if (!filter.accept(subject)) continue;
                return true;
            }
            if (filter.accept(subject)) continue;
            return false;
        }
        return !this.combineWithOr;
    }

    @Override
    public boolean filterable(Object subject) {
        for (CPResourceFilter filter : this.filters) {
            if (!filter.filterable(subject)) continue;
            return true;
        }
        return false;
    }

    public CombinedFilter combineWithOr() {
        this.combineWithOr = true;
        return this;
    }

    public CombinedFilter combineWithAnd() {
        this.combineWithOr = false;
        return this;
    }

    public CombinedFilter appendFilter(CPResourceFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public String toString() {
        return String.valueOf(this.combineWithOr ? "OR:" : "AND:") + this.filters.toString();
    }
}

