/*
 * Decompiled with CFR 0.152.
 */
package net.sf.corn.cps;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import net.sf.corn.cps.ResourceFilter;
import net.sf.corn.cps.RootedURL;

public class ClassFilter
extends ResourceFilter {
    private Set<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
    private Set<Class<?>> interfaces = new HashSet();
    private Set<Class<?>> superClasses = new HashSet();
    private boolean interfaceOnly = false;
    private boolean annotationOnly = false;
    private boolean enumOnly = false;
    private boolean classOnly = false;
    private boolean joinAnnotationsWithOr = true;
    private boolean joinInterfacesWithOr = true;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean accept(Object subject) {
        if (!super.accept(subject)) {
            return false;
        }
        if (!this.filterable(subject)) {
            return true;
        }
        if (subject instanceof Class) {
            Class clazz = (Class)subject;
            if (this.isInterfaceOnly() && !clazz.isInterface() || this.isAnnotationOnly() && !clazz.isAnnotation() || this.isEnumOnly() && !clazz.isEnum() || this.isClassOnly() && (clazz.isAnnotation() || clazz.isEnum() || clazz.isInterface())) {
                return false;
            }
            if (this.annotations.size() > 0) {
                boolean annotationFound = false;
                for (Class<? extends Annotation> annotation : this.annotations) {
                    if (!clazz.isAnnotationPresent(annotation)) {
                        if (this.joinAnnotationsWithOr) continue;
                        return false;
                    }
                    annotationFound = true;
                    if (this.joinAnnotationsWithOr) break;
                }
                if (!annotationFound) {
                    return false;
                }
            }
            if (this.interfaces.size() > 0) {
                void var5_7;
                boolean interfaceFound = false;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                boolean n2 = false;
                while (var5_7 < n) {
                    Class<?> definedInterface = classArray[var5_7];
                    for (Class<?> acceptableInterface : this.interfaces) {
                        if (!acceptableInterface.isAssignableFrom(definedInterface)) {
                            if (this.joinInterfacesWithOr) continue;
                            return false;
                        }
                        interfaceFound = true;
                        if (this.joinInterfacesWithOr) break;
                    }
                    if (interfaceFound) break;
                    ++var5_7;
                }
                if (!interfaceFound) {
                    return false;
                }
            }
            if (this.superClasses.size() > 0) {
                Class definedSuperClass = clazz.getSuperclass();
                boolean superClassFound = false;
                for (Class clazz2 : this.superClasses) {
                    if (!clazz2.isAssignableFrom(definedSuperClass)) continue;
                    superClassFound = true;
                    break;
                }
                if (!superClassFound) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean filterable(Object subject) {
        return subject != null && (subject instanceof RootedURL || subject instanceof URL || subject instanceof Class);
    }

    @Override
    public ClassFilter packageName(String name) {
        return (ClassFilter)super.packageName(name);
    }

    @Override
    public ClassFilter resourceName(String name) {
        return (ClassFilter)super.resourceName(name);
    }

    @Override
    public ClassFilter archiveName(String name) {
        return (ClassFilter)super.archiveName(name);
    }

    @Override
    public ClassFilter directoryName(String name) {
        return (ClassFilter)super.directoryName(name);
    }

    @Override
    public ClassFilter scanArchives(boolean scan) {
        return (ClassFilter)super.scanArchives(scan);
    }

    @Override
    public ClassFilter className(String name) {
        return (ClassFilter)super.className(name);
    }

    public ClassFilter annotation(Class<? extends Annotation> annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public ClassFilter interfaceClass(Class<?> interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException(String.valueOf(interfaceClass.getName()) + " not an interface!");
        }
        this.interfaces.add(interfaceClass);
        return this;
    }

    public ClassFilter superClass(Class<?> superClass) {
        this.superClasses.add(superClass);
        return this;
    }

    public ClassFilter joinAnnotationsWithOr() {
        this.joinAnnotationsWithOr = true;
        return this;
    }

    public ClassFilter joinInterfacesWithOr() {
        this.joinInterfacesWithOr = true;
        return this;
    }

    public ClassFilter joinAnnotationsWithAnd() {
        this.joinAnnotationsWithOr = false;
        return this;
    }

    public ClassFilter joinInterfacesWithAnd() {
        this.joinInterfacesWithOr = false;
        return this;
    }

    public ClassFilter allTypes() {
        this.interfaceOnly = false;
        this.annotationOnly = false;
        this.enumOnly = false;
        this.classOnly = false;
        return this;
    }

    public ClassFilter interfaceOnly() {
        this.allTypes();
        this.interfaceOnly = true;
        return this;
    }

    public ClassFilter annotationOnly() {
        this.allTypes();
        this.annotationOnly = true;
        return this;
    }

    public ClassFilter enumOnly() {
        this.allTypes();
        this.enumOnly = true;
        return this;
    }

    public ClassFilter classOnly() {
        this.allTypes();
        this.classOnly = true;
        return this;
    }

    public boolean isInterfaceOnly() {
        return this.interfaceOnly;
    }

    public boolean isAnnotationOnly() {
        return this.annotationOnly;
    }

    public boolean isEnumOnly() {
        return this.enumOnly;
    }

    public boolean isClassOnly() {
        return this.classOnly;
    }

    @Override
    public String toString() {
        return "ClassFilter [annotations=" + this.annotations + ", interfaces=" + this.interfaces + ", superClasses=" + this.superClasses + ", interfaceOnly=" + this.interfaceOnly + ", annotationOnly=" + this.annotationOnly + ", enumOnly=" + this.enumOnly + ", classOnly=" + this.classOnly + ", joinAnnotationsWithOr=" + this.joinAnnotationsWithOr + ", joinInterfacesWithOr=" + this.joinInterfacesWithOr + "]";
    }
}

