/*
 * Decompiled with CFR 0.152.
 */
package net.sf.corn.cps;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.corn.cps.CPResourceFilter;
import net.sf.corn.cps.RootedURL;

public class CPScanner {
    public static Set<URL> findRoots() {
        ClassLoader sysLoader;
        ClassLoader ctxLoader;
        HashSet<URL> urls = new HashSet<URL>();
        ClassLoader loader = ctxLoader = Thread.currentThread().getContextClassLoader();
        while (loader != null) {
            urls.addAll(CPScanner.findRootsByLoader(loader));
            loader = loader.getParent();
        }
        loader = sysLoader = CPScanner.class.getClassLoader();
        while (loader != null) {
            urls.addAll(CPScanner.findRootsByLoader(loader));
            loader = loader.getParent();
        }
        HashMap<URL, URL> replaceURLs = new HashMap<URL, URL>();
        HashSet<URL> derivedUrls = new HashSet<URL>();
        for (URL url : urls) {
            if (url.getProtocol().startsWith("vfs")) {
                try {
                    URLConnection conn = url.openConnection();
                    Object virtualFile = conn.getContent();
                    if (virtualFile.getClass().getName().equals("org.jboss.vfs.VirtualFile")) {
                        File file = (File)virtualFile.getClass().getMethod("getPhysicalFile", new Class[0]).invoke(virtualFile, new Object[0]);
                        String fileName = file.getCanonicalPath();
                        String name = (String)virtualFile.getClass().getMethod("getName", new Class[0]).invoke(virtualFile, new Object[0]);
                        if ((name = name.trim().toLowerCase()).endsWith("jar") || name.endsWith("zip") && fileName.endsWith("/contents")) {
                            fileName = fileName.replace("contents", name);
                        }
                        URL repURL = new URL("file:/" + fileName);
                        replaceURLs.put(url, repURL);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                if (url.toExternalForm().endsWith("WEB-INF/classes")) {
                    derivedUrls.add(new URL(url.toExternalForm().replace("WEB-INF/classes", "WEB-INF/lib")));
                    continue;
                }
                if (!url.toExternalForm().endsWith("WEB-INF/classes/")) continue;
                derivedUrls.add(new URL(url.toExternalForm().replace("WEB-INF/classes/", "WEB-INF/lib/")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        urls.removeAll(replaceURLs.keySet());
        urls.addAll(replaceURLs.values());
        urls.addAll(derivedUrls);
        replaceURLs.clear();
        for (URL url : urls) {
            for (URL rootUrl : urls) {
                if (url.equals(rootUrl) || !url.toExternalForm().startsWith(rootUrl.toExternalForm())) continue;
                if (replaceURLs.get(url) != null) {
                    URL settledUrl = (URL)replaceURLs.get(url);
                    if (!settledUrl.toExternalForm().startsWith(rootUrl.toExternalForm())) continue;
                    replaceURLs.put(url, rootUrl);
                    continue;
                }
                replaceURLs.put(url, rootUrl);
            }
        }
        urls.removeAll(replaceURLs.keySet());
        return urls;
    }

    private static Set<URL> findRootsByLoader(ClassLoader loader) {
        HashSet<URL> urls = new HashSet<URL>();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)loader;
            urls.addAll(Arrays.asList(urlLoader.getURLs()));
        } else {
            try {
                Enumeration<URL> urlEnum = loader.getResources("");
                while (urlEnum.hasMoreElements()) {
                    URL url = urlEnum.nextElement();
                    if (url.getProtocol().startsWith("bundleresource")) continue;
                    urls.add(url);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public static List<URL> scanResources(CPResourceFilter ... filters) {
        ArrayList<URL> resources = new ArrayList<URL>();
        Set<URL> roots = CPScanner.findRoots();
        CPScanner.filterResources(roots, filters);
        HashSet<RootedURL> allResources = new HashSet<RootedURL>();
        for (URL rootURL : roots) {
            List<RootedURL> rurls = CPScanner.scan(rootURL, false, filters);
            for (RootedURL rootedURL : rurls) {
                if (allResources.contains(rootedURL)) continue;
                allResources.add(rootedURL);
            }
        }
        for (RootedURL rURL : allResources) {
            resources.add(rURL.getResourceURL());
        }
        return resources;
    }

    public static List<Class<?>> scanClasses(CPResourceFilter ... filters) {
        ArrayList classList = new ArrayList();
        Set<URL> roots = CPScanner.findRoots();
        CPScanner.filterResources(roots, filters);
        if (roots.size() == 0) {
            return classList;
        }
        HashSet<RootedURL> allResources = new HashSet<RootedURL>();
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader appLoader = CPScanner.class.getClassLoader();
        for (URL rootURL : roots) {
            List<RootedURL> resources = CPScanner.scan(rootURL, true, filters);
            for (RootedURL rootedURL : resources) {
                if (allResources.contains(rootedURL)) continue;
                allResources.add(rootedURL);
            }
        }
        for (RootedURL rurl : allResources) {
            try {
                Class<?> clazz = CPScanner.loadClassByLoaders(rurl.getClassName(), contextLoader, appLoader);
                if (clazz.isSynthetic() || !Modifier.isPublic(clazz.getModifiers())) continue;
                clazz.getName();
                clazz.getCanonicalName();
                if (!CPScanner.acceptable(clazz, filters)) continue;
                classList.add(clazz);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return classList;
    }

    private static Class<?> loadClassByLoaders(String name, ClassLoader ... loaders) throws ClassNotFoundException {
        ClassNotFoundException lastException = null;
        Class<?> clazz = null;
        ClassLoader[] classLoaderArray = loaders;
        int n = loaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader loader = classLoaderArray[n2];
            try {
                lastException = null;
                clazz = loader.loadClass(name);
                break;
            }
            catch (ClassNotFoundException e) {
                lastException = e;
                ++n2;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return clazz;
    }

    private static void filterResources(Collection<?> resources, CPResourceFilter ... filters) {
        HashSet removed = new HashSet();
        for (Object resource : resources) {
            if (CPScanner.acceptable(resource, filters)) continue;
            removed.add(resource);
        }
        for (Object object : removed) {
            resources.remove(object);
        }
    }

    private static boolean acceptable(Object resource, CPResourceFilter ... filters) {
        if (resource == null) {
            return false;
        }
        if (filters == null) {
            return true;
        }
        CPResourceFilter[] cPResourceFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            CPResourceFilter filter = cPResourceFilterArray[n2];
            if (filter.filterable(resource) && !filter.accept(resource)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isArchive(File f) {
        return f != null && f.isFile() && (f.getName().toLowerCase().endsWith("jar") || f.getName().toLowerCase().endsWith("zip"));
    }

    private static boolean isClassUrl(URL url) {
        return url.toExternalForm().indexOf(".class") > 0;
    }

    private static URL convertToJarUrl(URL url) {
        URL jarUrl;
        if (url.toString().startsWith("jar")) {
            return url;
        }
        try {
            jarUrl = new URL("jar:" + url + "!/");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            jarUrl = url;
        }
        return jarUrl;
    }

    private static List<RootedURL> scan(URL rootURL, boolean scan4Classes, CPResourceFilter ... filters) {
        return CPScanner.scan(rootURL, rootURL, scan4Classes, filters);
    }

    private static List<RootedURL> scan(URL rootURL, URL url, boolean scan4Classes, CPResourceFilter ... filters) {
        ArrayList<RootedURL> resources = new ArrayList<RootedURL>();
        File file = null;
        long start = System.currentTimeMillis();
        if (url.getFile() != null && url.getFile().length() > 0) {
            try {
                file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (file != null) {
            try {
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        resources.addAll(CPScanner.scan(rootURL, child.toURI().toURL(), scan4Classes, filters));
                        ++n2;
                    }
                } else if (CPScanner.isArchive(file)) {
                    URL jarUrl = CPScanner.convertToJarUrl(file.toURI().toURL());
                    JarFile jarFile = new JarFile(file);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !scan4Classes || !entry.toString().endsWith(".class")) continue;
                        URL entryUrl = new URL(jarUrl + entry.toString());
                        RootedURL rurl = new RootedURL(jarUrl, entryUrl);
                        resources.add(rurl);
                    }
                } else {
                    RootedURL rurl = new RootedURL(rootURL, file.toURI().toURL());
                    if ((scan4Classes && CPScanner.isClassUrl(file.toURI().toURL()) || !scan4Classes && !CPScanner.isClassUrl(file.toURI().toURL())) && CPScanner.acceptable(rurl, filters)) {
                        resources.add(rurl);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (url.getFile().endsWith(".jar")) {
            System.out.println(String.valueOf(System.currentTimeMillis() - start) + "  " + url);
        }
        return resources;
    }
}

