/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.heartbeat;

import com.meidusa.toolkit.common.heartbeat.HeartbeatDelayed;
import com.meidusa.toolkit.common.heartbeat.Status;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatManager {
    static Logger logger = LoggerFactory.getLogger(HeartbeatManager.class);
    protected static final BlockingQueue<HeartbeatDelayed> HEART_BEAT_QUEUE = new DelayQueue<HeartbeatDelayed>();
    private static boolean isRunning = true;
    public static int DEFAULT_HEATBEAT_INTERVAL = Integer.getInteger("heartbeat.interval.default", 3);
    private static Thread heartbeatManagerThread = new Thread(){
        {
            this.setDaemon(true);
            this.setName("HeartbeatManagerThread");
        }

        @Override
        public void run() {
            HeartbeatDelayed delayed = null;
            while (isRunning) {
                try {
                    delayed = HEART_BEAT_QUEUE.take();
                    Status status = delayed.doCheck();
                    if (status == Status.INVALID || status == Status.OUT_OF_MEMORY) {
                        if (logger.isInfoEnabled()) {
                            logger.info("checked task taskName=" + delayed.getName() + ", Status=" + (Object)((Object)status));
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("checked task taskName=" + delayed.getName() + ", Status=" + (Object)((Object)status));
                    }
                    if (delayed.isCycle()) {
                        delayed.reset();
                        HeartbeatManager.addHeartbeat(delayed);
                        continue;
                    }
                    if (status == Status.INVALID || status == Status.OUT_OF_MEMORY) {
                        delayed.reset();
                        HeartbeatManager.addHeartbeat(delayed);
                        continue;
                    }
                    delayed.cancel();
                }
                catch (Exception e) {
                    logger.error("check task error", (Throwable)e);
                }
            }
        }
    };

    public static void addHeartbeat(HeartbeatDelayed delay) {
        if (!HEART_BEAT_QUEUE.contains(delay)) {
            HEART_BEAT_QUEUE.offer(delay);
        }
    }

    public static void removeHeartbeat(HeartbeatDelayed delay) {
        HEART_BEAT_QUEUE.remove(delay);
    }

    public static void shutdown() {
        isRunning = false;
        heartbeatManagerThread.stop();
    }

    static {
        heartbeatManagerThread.start();
    }
}

