/*
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details. 
 * 	You should have received a copy of the GNU General Public License along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.meidusa.toolkit.common.bean.config;

import java.util.HashMap;
import java.util.Map;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.meidusa.toolkit.common.util.StringUtil;

@SuppressWarnings("unchecked")
public class DocumentUtil {

	/**
	 * õΨһһڵ㣬һڵ㽫׳ ConfigurationException 쳣
	 * ûнڵʱ򷵻null
	 * 
	 * @param current
	 * @param tagName
	 * @return
	 */
	public static Element getTheOnlyElement(Element current, String tagName){
		NodeList nodeList = current.getElementsByTagName(tagName);
		if(nodeList.getLength() >1){
			throw new ConfigurationException(tagName +" elements length  over one!");
		}
		
		if(nodeList.getLength() ==1){
			return (Element)nodeList.item(0);
		}else{
			return null;
		}
	}
	
	public static BeanObjectEntityConfig loadBeanConfig(Element current) {
		BeanObjectEntityConfig<?> beanConfig = new BeanObjectEntityConfig();
		return loadBeanConfig(current,beanConfig);
	}
	
	public static BeanObjectEntityConfig loadBeanConfig(Element current,BeanObjectEntityConfig beanConfig) {
		if(current == null){
			return null;
		}
		NodeList children = current.getChildNodes();
        int childSize = children.getLength();
        beanConfig.setName(current.getAttribute("name"));
        Element element = DocumentUtil.getTheOnlyElement(current,"className");
       
        if(element != null){
        	Class beanClass;
        	String className = element.getTextContent().trim();
			try {
				beanClass = Class.forName(className);
				beanConfig.setBeanClass(beanClass);
			} catch (Exception e) {
				throw new ConfigurationException("className="+className +"  not found!");
			}
        	
        }else{
        	if(!StringUtil.isEmpty(current.getAttribute("class"))){
        		String className = current.getAttribute("class").trim();
        		try {
        			Class beanClass = Class.forName(current.getAttribute("class").trim());
        			beanConfig.setBeanClass(beanClass);
	        	} catch (Exception e) {
					throw new ConfigurationException("className="+className +"  not found!");
				}
        		
        	}
        }
        
        Map<String,Object> map = new HashMap<String,Object>();
        for (int i = 0; i < childSize; i++) {
            Node childNode = children.item(i);
            if (childNode instanceof Element) {
                Element child = (Element) childNode;
                final String nodeName = child.getNodeName();
	            if (nodeName.equals("property")) {
	            	String key = child.getAttribute("name");
	            	NodeList propertyNodes = child.getElementsByTagName("bean");
	            	if(propertyNodes.getLength() == 0){
		            	String value = child.getTextContent();
		            	map.put(key, StringUtil.isEmpty(value)?null:value.trim());
	            	}else{
	            		BeanObjectEntityConfig beanconfig = loadBeanConfig((Element) propertyNodes.item(0));
	            		map.put(key, beanconfig);
	            	}
	            }
            }
        }
        beanConfig.setParams(map);
		return beanConfig;
	}
}
