/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.bean.config;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import java.util.Map;
import java.util.Properties;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.collections.map.LRUMap;

public class ConfigUtil {
    private static Properties properties = new Properties();
    static LRUMap lruMap = new LRUMap(10000);

    public static void addProperties(Properties properties) {
        ConfigUtil.properties.putAll((Map<?, ?>)properties);
    }

    public static Properties getProperties() {
        return properties;
    }

    public static Object filter(String text) throws ConfigurationException {
        Object object = null;
        try {
            object = ConfigUtil.filter(text, BeanContextBean.getInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object == null) {
            object = ConfigUtil.filter(text, properties);
        }
        return object;
    }

    public static Object filter(String text, BeanContext context) {
        int propStart = -1;
        int propStop = -1;
        String propName = null;
        propStart = text.indexOf("${", 0);
        if (propStart < 0) {
            return text;
        }
        propStop = text.indexOf("}", propStart);
        if (propStop < 0) {
            throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
        }
        if (text.endsWith("}")) {
            propName = text.substring(propStart + 2, propStop);
            return context.getBean(propName);
        }
        return ConfigUtil.filter(text, properties);
    }

    public static String filter(String text, Properties properties) throws ConfigurationException {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int cur = 0;
        int textLen = text.length();
        int propStart = -1;
        int propStop = -1;
        String propName = null;
        String propValue = null;
        while (cur < textLen && (propStart = text.indexOf("${", cur)) >= 0) {
            result.append(text.substring(cur, propStart));
            propStop = text.indexOf("}", propStart);
            if (propStop < 0) {
                throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
            }
            propName = text.substring(propStart + 2, propStop);
            int index = propName.indexOf(":");
            String defValue = null;
            String key = propName;
            if (index > 0) {
                key = propName.substring(0, index);
                defValue = propName.substring(index + 1);
            }
            if ((propValue = properties.getProperty(key, defValue)) == null) {
                throw new ConfigurationException("No such property: " + propName);
            }
            result.append(propValue);
            cur = propStop + 1;
        }
        return result.append(text.substring(cur)).toString();
    }

    public static String filterWtihOGNL(String text, Map<String, Object> context, Object root) throws ConfigurationException {
        return ConfigUtil.filterWtihOGNL(text, context, root, System.getProperties());
    }

    public static String filterWtihOGNL(String text, Map<String, Object> context) throws ConfigurationException {
        return ConfigUtil.filterWtihOGNL(text, context, new Object(), System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String filterWtihOGNL(String text, Map<String, Object> context, Object root, Properties properties) throws ConfigurationException {
        if (properties == null) {
            properties = System.getProperties();
        }
        StringBuilder result = new StringBuilder();
        int cur = 0;
        int textLen = text.length();
        int propStart = -1;
        int propStop = -1;
        String propName = null;
        String propValue = null;
        while (cur < textLen && (propStart = text.indexOf("${", cur)) >= 0) {
            result.append(text.substring(cur, propStart));
            propStop = text.indexOf("}", propStart);
            if (propStop < 0) {
                throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
            }
            propName = text.substring(propStart + 2, propStop);
            if (propName.startsWith("#") || propName.startsWith("@")) {
                try {
                    Object tree = lruMap.get((Object)propName);
                    if (tree == null) {
                        LRUMap lRUMap = lruMap;
                        synchronized (lRUMap) {
                            tree = lruMap.get((Object)propName);
                            if (tree == null) {
                                tree = Ognl.parseExpression((String)propName);
                                lruMap.put((Object)propName, tree);
                            }
                        }
                    }
                    propValue = Ognl.getValue((Object)tree, context, (Object)root).toString();
                }
                catch (OgnlException e) {
                    throw new ConfigurationException("parseException expression=" + propName, e);
                }
            }
            propValue = properties.getProperty(propName);
            if (propValue == null) {
                throw new ConfigurationException("No such property: " + propName);
            }
            result.append(propValue);
            cur = propStop + 1;
        }
        return result.append(text.substring(cur)).toString();
    }

    static {
        properties.putAll((Map<?, ?>)System.getProperties());
    }
}

