/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.bean.config;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.config.BeanObjectEntityConfig;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.bean.config.PropertyTransfer;
import com.meidusa.toolkit.common.util.StringUtil;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ParameterMapping {
    private static Logger logger = Logger.getLogger(ParameterMapping.class);
    private static Map<Class<?>, PropertyDescriptor[]> propertyDescriptorMap = new HashMap();
    private static Map<Class<?>, PropertyTransfer<?>> stringTransferMap = new HashMap();
    private static Map<Class<?>, Field[]> fieldsMap = new HashMap();

    public static void registerTransfer(Class<?> type, PropertyTransfer<?> transfer) {
        stringTransferMap.put(type, transfer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyDescriptor[] getDescriptors(Class<?> clazz) {
        PropertyDescriptor[] mDescriptors = propertyDescriptorMap.get(clazz);
        if (mDescriptors == null) {
            Map<Class<?>, PropertyDescriptor[]> map = propertyDescriptorMap;
            synchronized (map) {
                mDescriptors = propertyDescriptorMap.get(clazz);
                if (mDescriptors == null) {
                    try {
                        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
                        int i = 0;
                        while (i < descriptors.length) {
                            if (descriptors[i].getPropertyType() != null) {
                                list.add(descriptors[i]);
                            }
                            ++i;
                        }
                        mDescriptors = new PropertyDescriptor[list.size()];
                        list.toArray(mDescriptors);
                    }
                    catch (IntrospectionException ie) {
                        ie.printStackTrace();
                        mDescriptors = new PropertyDescriptor[]{};
                    }
                    propertyDescriptorMap.put(clazz, mDescriptors);
                }
            }
        }
        return mDescriptors;
    }

    public static void mappingObject(Object object, Map<String, Object> parameter) {
        ParameterMapping.mappingObject(object, parameter, null);
    }

    public static void mappingObject(Object object, Map<String, Object> parameter, BeanContext context) {
        PropertyDescriptor[] descriptors = ParameterMapping.getDescriptors(object.getClass());
        int i = 0;
        while (i < descriptors.length) {
            Object[] obj;
            Object[] value = obj = parameter.get(descriptors[i].getName());
            Class<?> cls = descriptors[i].getPropertyType();
            if (obj instanceof String) {
                String string = (String)obj;
                if (!StringUtil.isEmpty((String)string)) {
                    if (ParameterMapping.isPrimitiveType(cls)) {
                        string = (String)ConfigUtil.filter(string);
                        value = ParameterMapping.deStringize(cls, string);
                    } else {
                        value = ConfigUtil.filter(string, context);
                    }
                }
            } else if (obj instanceof BeanObjectEntityConfig) {
                value = ParameterMapping.newBean((BeanObjectEntityConfig)obj);
            } else if (obj instanceof BeanObjectEntityConfig[]) {
                ArrayList<Object> list = new ArrayList<Object>();
                BeanObjectEntityConfig[] beanObjectEntityConfigArray = (BeanObjectEntityConfig[])obj;
                int n = beanObjectEntityConfigArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BeanObjectEntityConfig beanconfig = beanObjectEntityConfigArray[n2];
                    list.add(ParameterMapping.newBean(beanconfig));
                    ++n2;
                }
                value = list.toArray();
            }
            if (cls != null) {
                try {
                    if (value != null) {
                        Method method = descriptors[i].getWriteMethod();
                        if (method != null) {
                            method.invoke(object, new Object[]{value});
                        } else if (logger.isInfoEnabled()) {
                            logger.info((Object)(object.getClass() + "@" + descriptors[i].getName() + " can not write able"));
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static Object newBean(BeanObjectEntityConfig<?> beanConfig) {
        Object beanvalue = beanConfig.createBeanObject(true);
        if (beanvalue instanceof Map) {
            Map map = (Map)beanvalue;
            for (Map.Entry<String, Object> entry : beanConfig.getParams().entrySet()) {
                String key = entry.getKey();
                Object mapValue = entry.getValue();
                if (mapValue instanceof BeanObjectEntityConfig) {
                    BeanObjectEntityConfig mapBeanConfig = (BeanObjectEntityConfig)entry.getValue();
                    mapValue = mapBeanConfig.createBeanObject(true);
                    ParameterMapping.mappingObject(mapValue, mapBeanConfig.getParams());
                }
                map.put(key, mapValue);
            }
        } else if (!(beanvalue instanceof List)) {
            ParameterMapping.mappingObject(beanvalue, beanConfig.getParams());
        }
        return beanvalue;
    }

    public static PropertyTransfer<?> lookup(Class fieldType) {
        for (Map.Entry<Class<?>, PropertyTransfer<?>> entry : stringTransferMap.entrySet()) {
            try {
                Class<?> clazz = entry.getKey();
                if (!clazz.equals(fieldType) && clazz.asSubclass(fieldType) == null) continue;
                return entry.getValue();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mappingObjectField(Object object, Map parameter, Class stopClass) {
        Class<?> clazz = object.getClass();
        while (clazz != stopClass && clazz != null) {
            Field[] fields = null;
            fields = fieldsMap.get(clazz);
            if (fields == null) {
                Map<Class<?>, Field[]> map = fieldsMap;
                synchronized (map) {
                    fields = fieldsMap.get(clazz);
                    if (fields == null) {
                        fields = clazz.getDeclaredFields();
                        fieldsMap.put(clazz, fields);
                    }
                }
            }
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj;
                Field field = fieldArray[n2];
                Object value = obj = parameter.get(field.getName());
                Class<?> cls = field.getType();
                if (obj instanceof String) {
                    String string = (String)obj;
                    if (!StringUtil.isEmpty((String)string)) {
                        string = (String)ConfigUtil.filter(string);
                    }
                    if (ParameterMapping.isPrimitiveType(cls)) {
                        value = ParameterMapping.deStringize(cls, string);
                    } else {
                        PropertyTransfer<?> transfer = ParameterMapping.lookup(cls);
                        if (transfer != null) {
                            value = transfer.transfer(string);
                        }
                    }
                    if (value != null && Modifier.isPublic(field.getModifiers())) {
                        try {
                            field.set(object, value);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mappingObjectField(Object object, Map parameter, Map context, Object root, Class stopClass) {
        Class<?> clazz = object.getClass();
        while (clazz != stopClass && clazz != null) {
            Field[] fields = null;
            fields = fieldsMap.get(clazz);
            if (fields == null) {
                Map<Class<?>, Field[]> map = fieldsMap;
                synchronized (map) {
                    fields = fieldsMap.get(clazz);
                    if (fields == null) {
                        fields = clazz.getDeclaredFields();
                        fieldsMap.put(clazz, fields);
                    }
                }
            }
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj;
                Field field = fieldArray[n2];
                Object value = obj = parameter.get(field.getName());
                Class<?> cls = field.getType();
                if (obj instanceof String) {
                    String string = (String)obj;
                    if (!StringUtil.isEmpty((String)string)) {
                        string = ConfigUtil.filterWtihOGNL(string, context, root);
                    }
                    if (ParameterMapping.isPrimitiveType(cls)) {
                        value = ParameterMapping.deStringize(cls, string);
                    } else {
                        PropertyTransfer<?> transfer = ParameterMapping.lookup(cls);
                        if (transfer != null) {
                            value = transfer.transfer(string);
                        }
                    }
                    if (value != null) {
                        if (!Modifier.isPublic(field.getModifiers())) {
                            field.setAccessible(true);
                        }
                        try {
                            field.set(object, value);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static Object deStringize(Class<?> cls, String string) {
        Class<?> value = null;
        if (cls.equals(String.class)) {
            value = string;
        } else if (cls.equals(Boolean.TYPE)) {
            value = Boolean.valueOf(string);
        } else if (cls.equals(Byte.TYPE)) {
            value = Byte.valueOf(string);
        } else if (cls.equals(Short.TYPE)) {
            value = Short.valueOf(string);
        } else if (cls.equals(Integer.TYPE)) {
            value = Integer.valueOf(string);
        } else if (cls.equals(Long.TYPE)) {
            value = Long.valueOf(string);
        } else if (cls.equals(Double.TYPE)) {
            value = Double.valueOf(string);
        } else if (cls.equals(Float.TYPE)) {
            value = Float.valueOf(string);
        } else if (cls.equals(Boolean.class) || cls.equals(Byte.class) || cls.equals(Short.class) || cls.equals(Integer.class) || cls.equals(Long.class) || cls.equals(Float.class) || cls.equals(Double.class)) {
            try {
                Method method = cls.getMethod("valueOf", String.class);
                value = method.invoke(null, string);
            }
            catch (Throwable t) {
                value = null;
            }
        } else if (cls.equals(Class.class)) {
            try {
                value = Class.forName(string);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)(String.valueOf(string) + " class not found"), (Throwable)e);
            }
        } else {
            value = null;
        }
        return value;
    }

    public static boolean isPrimitiveType(Class<?> cls) {
        return cls.equals(String.class) || cls.equals(Boolean.TYPE) || cls.equals(Byte.TYPE) || cls.equals(Short.TYPE) || cls.equals(Integer.TYPE) || cls.equals(Long.TYPE) || cls.equals(Double.TYPE) || cls.equals(Float.TYPE) || cls.equals(Boolean.class) || cls.equals(Byte.class) || cls.equals(Short.class) || cls.equals(Integer.class) || cls.equals(Long.class) || cls.equals(Float.class) || cls.equals(Double.class) || cls.equals(Class.class);
    }
}

